/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.html.meta.IMetaElement;
import com.helger.html.meta.MetaElement;
import com.helger.html.meta.MetaElementList;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.util.XMLMapHandler;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonMetaElements {
    public static final String DEFAULT_FILENAME = "html/metatags.xml";
    private static final String REQUEST_ATTR_METAELEMENTS = PhotonMetaElements.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonMetaElements.class);
    private static final MetaElementList s_aGlobal = new MetaElementList();
    private static final SimpleLock s_aLock = new SimpleLock();

    private PhotonMetaElements() {
    }

    public static void _readMetaElements(@Nonnull IReadableResource iReadableResource, @Nonnull MetaElementList metaElementList) {
        ValueEnforcer.notNull(iReadableResource, "Res");
        ValueEnforcer.notNull(metaElementList, "Target");
        if (iReadableResource.exists()) {
            CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
            if (XMLMapHandler.readMap(iReadableResource, commonsLinkedHashMap).isFailure()) {
                LOGGER.error("Failed to read meta element file " + iReadableResource.getPath());
            }
            for (Map.Entry entry : commonsLinkedHashMap.entrySet()) {
                metaElementList.addMetaElement(MetaElement.createMeta((String)entry.getKey(), (String)entry.getValue()));
            }
        }
    }

    public static void readMetaElementsForGlobal(@Nonnull IReadableResource iReadableResource) {
        PhotonMetaElements._readMetaElements(iReadableResource, s_aGlobal);
    }

    public static void registerMetaElementForGlobal(@Nonnull IMetaElement iMetaElement) {
        s_aGlobal.addMetaElement(iMetaElement);
    }

    public static void unregisterMetaElementForGlobal(@Nullable String string) {
        s_aGlobal.removeMetaElement(string);
    }

    public static void unregisterAllMetaElementsFromGlobal() {
        s_aGlobal.removeAllMetaElements();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IMetaElement> getAllRegisteredMetaElementsForGlobal() {
        return s_aGlobal.getAllMetaElements();
    }

    public static void getAllRegisteredMetaElementsForGlobal(@Nonnull Collection<? super IMetaElement> collection) {
        s_aGlobal.getAllMetaElements(collection);
    }

    public static boolean hasRegisteredMetaElementsForGlobal() {
        return s_aGlobal.hasMetaElements();
    }

    @Nullable
    private static MetaElementList _getPerRequestSet(boolean bl) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScope();
        return s_aLock.lockedGet(() -> {
            MetaElementList metaElementList = (MetaElementList)iRequestWebScope.attrs().getCastedValue(REQUEST_ATTR_METAELEMENTS);
            if (metaElementList == null && bl) {
                metaElementList = new MetaElementList();
                iRequestWebScope.attrs().putIn(REQUEST_ATTR_METAELEMENTS, metaElementList);
            }
            return metaElementList;
        });
    }

    public static void registerMetaElementForThisRequest(@Nonnull IMetaElement iMetaElement) {
        PhotonMetaElements._getPerRequestSet(true).addMetaElement(iMetaElement);
    }

    public static void unregisterMetaElementFromThisRequest(@Nullable String string) {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        if (metaElementList != null) {
            metaElementList.removeMetaElement(string);
        }
    }

    public static void unregisterAllMetaElementsFromThisRequest() {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        if (metaElementList != null) {
            metaElementList.removeAllMetaElements();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IMetaElement> getAllRegisteredMetaElementsForThisRequest() {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        return metaElementList == null ? new CommonsArrayList() : metaElementList.getAllMetaElements();
    }

    public static void getAllRegisteredMetaElementsForThisRequest(@Nonnull Collection<? super IMetaElement> collection) {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        if (metaElementList != null) {
            metaElementList.getAllMetaElements(collection);
        }
    }

    public static boolean hasRegisteredMetaElementsForThisRequest() {
        MetaElementList metaElementList = PhotonMetaElements._getPerRequestSet(false);
        return metaElementList != null && metaElementList.hasMetaElements();
    }
}

