/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.relative.FileRelativeIO;
import com.helger.commons.io.relative.IFileRelativeIO;
import com.helger.commons.io.relative.IPathRelativeIO;
import com.helger.commons.io.relative.PathRelativeIO;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class WebFileIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebFileIO.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IFileRelativeIO s_aDataPath;
    @GuardedBy(value="s_aRWLock")
    private static IPathRelativeIO s_aServletContextPath;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bSilentMode;

    private WebFileIO() {
    }

    public static boolean setSilentMode(boolean bl) {
        return s_aRWLock.writeLockedBoolean(() -> {
            boolean bl2 = s_bSilentMode;
            s_bSilentMode = bl;
            return bl2;
        });
    }

    public static boolean isSilentMode() {
        return s_aRWLock.readLockedBoolean(() -> s_bSilentMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPaths(@Nonnull File file, @Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notNull(file, "DataPath");
        ValueEnforcer.notEmpty(string, "ServletContextPath");
        s_aRWLock.writeLock().lock();
        try {
            boolean bl2;
            if (s_aDataPath != null) {
                throw new IllegalStateException("Another data path is already present: " + s_aDataPath);
            }
            if (s_aServletContextPath != null) {
                throw new IllegalStateException("Another servlet context path is already present: " + s_aServletContextPath);
            }
            boolean bl3 = bl2 = !WebFileIO.isSilentMode();
            if (bl2 && LOGGER.isInfoEnabled()) {
                LOGGER.info("Using '" + file + "' as the data path");
            }
            s_aDataPath = new FileRelativeIO(file);
            if (bl) {
                FileRelativeIO.internalCheckAccessRights(file);
            }
            if (bl2 && LOGGER.isInfoEnabled()) {
                LOGGER.info("Using '" + string + "' as the servlet context path");
            }
            s_aServletContextPath = new PathRelativeIO(string);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static void resetPaths() {
        s_aRWLock.writeLocked(() -> {
            s_aDataPath = null;
            s_aServletContextPath = null;
        });
    }

    public static boolean isInited() {
        return s_aRWLock.readLockedBoolean(() -> s_aDataPath != null);
    }

    @Nonnull
    public static IFileRelativeIO getDataIO() {
        IFileRelativeIO iFileRelativeIO = s_aRWLock.readLockedGet(() -> s_aDataPath);
        if (iFileRelativeIO == null) {
            throw new IllegalStateException("Data path was not initialized!");
        }
        return iFileRelativeIO;
    }

    @Nonnull
    public static IPathRelativeIO getServletContextIO() {
        IPathRelativeIO iPathRelativeIO = s_aRWLock.readLockedGet(() -> s_aServletContextPath);
        if (iPathRelativeIO == null) {
            throw new IllegalStateException("Servlet context path was not initialized!");
        }
        return iPathRelativeIO;
    }

    static {
        s_bSilentMode = false;
    }
}

