/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.mock;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.NonBlockingStack;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.photon.app.PhotonAppInit;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.io.WebIOIntIDFactory;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PhotonAppTestInit {
    private PhotonAppTestInit() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingStack<Runnable> init(@Nonnull File file, @Nonnull @Nonempty String string) {
        NonBlockingStack<Runnable> nonBlockingStack = new NonBlockingStack<Runnable>();
        PhotonAppInit.startUp();
        nonBlockingStack.push(() -> PhotonAppInit.shutdown());
        WebFileIO.initPaths(file, string, false);
        nonBlockingStack.push(() -> WebFileIO.resetPaths());
        if (!GlobalIDFactory.hasPersistentIntIDFactory()) {
            GlobalIDFactory.setPersistentIntIDFactory(new WebIOIntIDFactory("ph-oton-basic.id"));
            nonBlockingStack.push(() -> GlobalIDFactory.setPersistentIntIDFactory(null));
        }
        return nonBlockingStack;
    }
}

