/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.NonBlockingStack;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.dao.AbstractDAO;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.mock.PhotonAppTestInit;
import com.helger.scope.mock.ScopeTestRule;
import com.helger.servlet.ServletContextPathHolder;
import java.io.File;
import javax.annotation.Nonnull;

public class PhotonAppTestRule
extends ScopeTestRule {
    private final File m_aDataPath;
    private final String m_sServletContextPath;
    private boolean m_bDeleteAllData = false;
    private boolean m_bOldDAOSilentMode;
    private boolean m_bOldWebFileIOSilentMode;
    private boolean m_bOldSCCtxHolderSilentMode;
    private NonBlockingStack<Runnable> m_aCleansingRules;

    public PhotonAppTestRule() {
        this(ScopeTestRule.STORAGE_PATH);
    }

    public PhotonAppTestRule(@Nonnull File file) {
        this(file, file.getAbsolutePath());
    }

    public PhotonAppTestRule(@Nonnull File file, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(file, "DataPath");
        ValueEnforcer.notEmpty(string, "ServletContextPath");
        this.m_aDataPath = file.getAbsoluteFile();
        this.m_sServletContextPath = string;
    }

    @Nonnull
    public final File getDataPath() {
        return this.m_aDataPath;
    }

    @Nonnull
    @Nonempty
    public final String getServletContextPath() {
        return this.m_sServletContextPath;
    }

    @Nonnull
    public final PhotonAppTestRule setDeleteAllData(boolean bl) {
        this.m_bDeleteAllData = bl;
        return this;
    }

    @Override
    public void before() {
        this.m_bOldDAOSilentMode = AbstractDAO.setSilentMode(true);
        this.m_bOldWebFileIOSilentMode = WebFileIO.setSilentMode(true);
        this.m_bOldSCCtxHolderSilentMode = ServletContextPathHolder.setSilentMode(true);
        super.before();
        this.m_aCleansingRules = PhotonAppTestInit.init(this.m_aDataPath, this.m_sServletContextPath);
        if (this.m_bDeleteAllData) {
            FileOperationManager.INSTANCE.deleteDirRecursiveIfExisting(WebFileIO.getDataIO().getBasePathFile());
            FileOperationManager.INSTANCE.createDir(WebFileIO.getDataIO().getBasePathFile());
        }
    }

    @Override
    public void after() {
        if (this.m_aCleansingRules != null) {
            while (this.m_aCleansingRules.isNotEmpty()) {
                Runnable runnable = this.m_aCleansingRules.pop();
                runnable.run();
            }
        }
        super.after();
        ServletContextPathHolder.setSilentMode(this.m_bOldSCCtxHolderSilentMode);
        WebFileIO.setSilentMode(this.m_bOldWebFileIOSilentMode);
        AbstractDAO.setSilentMode(this.m_bOldDAOSilentMode);
    }
}

