/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.url.ISimpleURL;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.metadata.HCLink;
import com.helger.html.hc.html.script.HCScriptFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EWebSiteResourceType implements IHasID<String>,
IHasDisplayName
{
    JS("js", CMimeType.TEXT_JAVASCRIPT, ".js", "JavaScript"){

        @Override
        @Nonnull
        public IHCNode createNode(@Nonnull ISimpleURL iSimpleURL, @Nullable ICSSMediaList iCSSMediaList) {
            return new HCScriptFile().setSrc(iSimpleURL);
        }
    }
    ,
    CSS("css", CMimeType.TEXT_CSS, ".css", "CSS"){

        @Override
        @Nonnull
        public IHCNode createNode(@Nonnull ISimpleURL iSimpleURL, @Nullable ICSSMediaList iCSSMediaList) {
            return HCLink.createCSSLink(iSimpleURL).setMedia(iCSSMediaList);
        }
    };

    private final String m_sID;
    private final IMimeType m_aMimeType;
    private final String m_sFileExtension;
    private final String m_sDisplayName;

    private EWebSiteResourceType(@Nonnull @Nonempty String string2, @Nonnull @Nonempty IMimeType iMimeType, String string3, String string4) {
        this.m_sID = string2;
        this.m_aMimeType = iMimeType;
        this.m_sFileExtension = string3;
        this.m_sDisplayName = string4;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    @Nonempty
    public String getFileExtension() {
        return this.m_sFileExtension;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public abstract IHCNode createNode(@Nonnull ISimpleURL var1, @Nullable ICSSMediaList var2);

    @Nullable
    public static EWebSiteResourceType getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EWebSiteResourceType.class, string);
    }
}

