/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.visit.AbstractModifyingCSSUrlVisitor;
import com.helger.css.decl.visit.CSSVisitor;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.url.LinkHelper;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public class WebSiteResource {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResource.class);
    private final EWebSiteResourceType m_eResourceType;
    private final String m_sPath;
    private final Charset m_aCharset;
    private final IReadableResource m_aResource;
    private final boolean m_bResourceExists;
    private final byte[] m_aContentHash;
    private final String m_sContentHash;
    private transient int m_nHashCode = 0;

    public WebSiteResource(@Nonnull EWebSiteResourceType eWebSiteResourceType, @Nonnull @Nonempty String string, @Nonnull Charset charset) {
        this.m_eResourceType = ValueEnforcer.notNull(eWebSiteResourceType, "ResourceType");
        this.m_sPath = ValueEnforcer.notEmpty(string, "Path");
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
        this.m_aResource = PhotonAppSettings.getURIToURLConverter().getAsResource(string);
        this.m_bResourceExists = this.m_aResource.exists();
        if (this.m_bResourceExists && !(this.m_aResource instanceof URLResource)) {
            byte[] byArray = ArrayHelper.EMPTY_BYTE_ARRAY;
            try {
                InputStream inputStream = this.m_aResource.getInputStream();
                if (inputStream != null) {
                    byArray = MessageDigestValue.create(inputStream, EMessageDigestAlgorithm.SHA_512).bytes();
                }
            }
            catch (IOException | NullPointerException exception) {
                LOGGER.error("Failed to create message digest of " + this.m_aResource.getPath(), exception);
            }
            this.m_aContentHash = byArray;
            this.m_sContentHash = StringHelper.getHexEncoded(byArray);
        } else {
            this.m_aContentHash = ArrayHelper.EMPTY_BYTE_ARRAY;
            this.m_sContentHash = "";
        }
    }

    @Nonnull
    public EWebSiteResourceType getResourceType() {
        return this.m_eResourceType;
    }

    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    private String _readAndParseCSS(@Nonnull IHasInputStream iHasInputStream, final @Nonnull @Nonempty String string, boolean bl) {
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromStream(iHasInputStream, this.m_aCharset, ECSSVersion.CSS30);
        if (cascadingStyleSheet == null) {
            LOGGER.error("Failed to parse CSS. Returning 'as-is'");
            return StreamHelper.getAllBytesAsString(iHasInputStream, this.m_aCharset);
        }
        CSSVisitor.visitCSSUrl(cascadingStyleSheet, new AbstractModifyingCSSUrlVisitor(){

            @Override
            protected String getModifiedURI(@Nonnull String string2) {
                if (LinkHelper.hasKnownProtocol(string2)) {
                    return string2;
                }
                return FilenameHelper.getCleanConcatenatedUrlPath(string, string2);
            }
        });
        return new CSSWriter(ECSSVersion.CSS30, !bl).setWriteHeaderText(false).setWriteFooterText(false).getCSSAsString(cascadingStyleSheet);
    }

    @Nullable
    public String getContent(boolean bl) {
        if (!this.m_bResourceExists) {
            return null;
        }
        switch (this.m_eResourceType) {
            case JS: {
                return StreamHelper.getAllBytesAsString(this.m_aResource, this.m_aCharset);
            }
            case CSS: {
                String string = FilenameHelper.getPath(PhotonAppSettings.getURIToURLConverter().getAsURL(this.m_sPath).getAsStringWithEncodedParameters());
                return this._readAndParseCSS(this.m_aResource, string, bl);
            }
        }
        throw new IllegalStateException("Unsupported resource type " + this.m_eResourceType);
    }

    public boolean isExisting() {
        return this.m_bResourceExists;
    }

    @Nullable
    public String getAsURLString() {
        URL uRL = this.m_aResource.getAsURL();
        if (uRL == null) {
            return null;
        }
        return uRL.toExternalForm();
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentHashBytes() {
        return ArrayHelper.getCopy(this.m_aContentHash);
    }

    @Nonnull
    public String getContentHashAsString() {
        return this.m_sContentHash;
    }

    @Nonnull
    public ISimpleURL getAsURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string = this.m_sContentHash.length() >= 16 ? this.m_sContentHash.substring(0, 16) : "";
        return (ISimpleURL)PhotonAppSettings.getURIToURLConverter().getAsURL(iRequestWebScopeWithoutResponse, this.m_sPath).addIf("version", string, StringHelper::hasText);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        WebSiteResource webSiteResource = (WebSiteResource)object;
        return this.m_eResourceType.equals(webSiteResource.m_eResourceType) && this.m_sPath.equals(webSiteResource.m_sPath) && this.m_aCharset.equals(webSiteResource.m_aCharset);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eResourceType)).append(this.m_sPath).append(this.m_aCharset).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ResourceType", this.m_eResourceType).append("Path", this.m_sPath).append("Charset", this.m_aCharset).getToString();
    }
}

