/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCConditionalCommentNode;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.resource.WebSiteResource;
import com.helger.photon.app.resource.WebSiteResourceWithCondition;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WebSiteResourceBundle {
    private final ICommonsList<WebSiteResource> m_aResources = new CommonsArrayList<WebSiteResource>();
    private final String m_sConditionalComment;
    private final boolean m_bIsBundlable;
    private final CSSMediaList m_aMediaList;
    private final EWebSiteResourceType m_eResourceType;
    private transient int m_nHashCode = 0;

    public WebSiteResourceBundle(@Nonnull @Nonempty List<WebSiteResourceWithCondition> list, @Nullable String string, boolean bl, @Nullable ICSSMediaList iCSSMediaList) {
        ValueEnforcer.notEmptyNoNullValue(list, "Resources");
        this.m_aResources.addAllMapped(list, WebSiteResourceWithCondition::getResource);
        this.m_sConditionalComment = string;
        this.m_bIsBundlable = bl;
        this.m_aMediaList = iCSSMediaList == null || iCSSMediaList.hasNoMedia() ? null : new CSSMediaList(iCSSMediaList);
        this.m_eResourceType = this.m_aResources.getFirst().getResourceType();
        for (WebSiteResourceWithCondition webSiteResourceWithCondition : list) {
            if (webSiteResourceWithCondition.getResource().getResourceType().equals(this.m_eResourceType)) continue;
            throw new IllegalArgumentException("The passed resources are mixed of different resource types: " + list);
        }
    }

    @Nonnegative
    public int getResourceCount() {
        return this.m_aResources.size();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<WebSiteResource> getAllResources() {
        return (ICommonsList)this.m_aResources.getClone();
    }

    @Nullable
    public WebSiteResource getResourceAtIndex(@Nonnegative int n) {
        return (WebSiteResource)this.m_aResources.getAtIndex(n);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<String> getAllResourcePaths() {
        return this.m_aResources.getAllMapped(WebSiteResource::getPath);
    }

    public boolean hasConditionalComment() {
        return StringHelper.hasText(this.m_sConditionalComment);
    }

    @Nullable
    public String getConditionalComment() {
        return this.m_sConditionalComment;
    }

    public boolean isBundlable() {
        return this.m_bIsBundlable;
    }

    @Nullable
    public ICSSMediaList getMediaList() {
        return this.m_aMediaList;
    }

    public boolean hasMediaList() {
        return this.m_aMediaList != null;
    }

    @Nonnull
    public EWebSiteResourceType getResourceType() {
        return this.m_eResourceType;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_eResourceType.getMimeType();
    }

    @Nonnull
    public IHCNode getWrapped(@Nonnull IHCNode iHCNode) {
        if (this.hasConditionalComment()) {
            return new HCConditionalCommentNode(this.m_sConditionalComment, iHCNode);
        }
        return iHCNode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        WebSiteResourceBundle webSiteResourceBundle = (WebSiteResourceBundle)object;
        return this.m_aResources.equals(webSiteResourceBundle.m_aResources) && EqualsHelper.equals(this.m_sConditionalComment, webSiteResourceBundle.m_sConditionalComment) && this.m_bIsBundlable == webSiteResourceBundle.m_bIsBundlable && EqualsHelper.equals(this.m_aMediaList, webSiteResourceBundle.m_aMediaList);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aResources)).append(this.m_sConditionalComment).append(this.m_bIsBundlable).append(this.m_aMediaList).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Resources", this.m_aResources).appendIfNotNull("ConditionalComment", this.m_sConditionalComment).append("IsBundlable", this.m_bIsBundlable).appendIfNotNull("MediaList", this.m_aMediaList).getToString();
    }
}

