/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.file.FileSystemIterator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ECSSMedium;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonSimpleDAO;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.resource.IWebSiteResourceBundleProvider;
import com.helger.photon.app.resource.WebSiteResource;
import com.helger.photon.app.resource.WebSiteResourceBundle;
import com.helger.photon.app.resource.WebSiteResourceBundleSerialized;
import com.helger.photon.app.resource.WebSiteResourceWithCondition;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import java.io.File;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSiteResourceBundleManager
extends AbstractPhotonSimpleDAO
implements IWebSiteResourceBundleProvider {
    private static final String ELEMENT_RESOURCE_BUNDLES = "resource-bundles";
    private static final String ELEMENT_RESOURCE_BUNDLE = "resource-bundle";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CREATIONDT = "creationdt";
    private static final String ATTR_CONDITIONAL_COMMENT = "conditionalcomment";
    private static final String ATTR_IS_BUNDLABLE = "canbebundled";
    private static final String ELEMENT_MEDIUM = "medium";
    private static final String ELEMENT_RESOURCE = "resource";
    private static final String ATTR_RESOURCE_TYPE = "resourcetype";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_URL = "url";
    private static final String ATTR_CONTENT_HASH = "contenthash";
    private static final String ATTR_CHARSET = "charset";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResourceBundleManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<WebSiteResourceBundle, String> m_aMapToData = new CommonsHashMap<WebSiteResourceBundle, String>();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, WebSiteResourceBundleSerialized> m_aMapToBundle = new CommonsHashMap<String, WebSiteResourceBundleSerialized>();

    public WebSiteResourceBundleManager(@Nullable String string) throws DAOException {
        super(string);
        this.initialRead();
    }

    @Override
    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        boolean bl = false;
        for (IMicroElement object : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_RESOURCE_BUNDLE)) {
            Object object2;
            Object object32;
            boolean bl2 = false;
            String string = object.getAttributeValue(ATTR_ID);
            LocalDateTime localDateTime = object.getAttributeValueWithConversion(ATTR_CREATIONDT, LocalDateTime.class);
            String string2 = object.getAttributeValue(ATTR_CONDITIONAL_COMMENT);
            String string3 = object.getAttributeValue(ATTR_IS_BUNDLABLE);
            boolean bl3 = StringParser.parseBool(string3, true);
            CSSMediaList cSSMediaList = new CSSMediaList();
            for (IMicroElement iMicroElement : object.getAllChildElements(ELEMENT_MEDIUM)) {
                object32 = iMicroElement.getTextContentTrimmed();
                object2 = ECSSMedium.getFromNameOrNull((String)object32);
                if (object2 == null) {
                    throw new IllegalStateException("Failed to resolve CSS medium '" + (String)object32 + "'");
                }
                cSSMediaList.addMedium((ECSSMedium)object2);
            }
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            if (!WebSiteResourceBundleSerialized.getResource(string).exists()) {
                LOGGER.warn("No serialized bundle with ID '" + string + "' exists.");
                bl2 = true;
            } else {
                for (Object object32 : object.getAllChildElements(ELEMENT_RESOURCE)) {
                    object2 = object32.getAttributeValue(ATTR_RESOURCE_TYPE);
                    EWebSiteResourceType eWebSiteResourceType = EWebSiteResourceType.getFromIDOrNull((String)object2);
                    if (eWebSiteResourceType == null) {
                        LOGGER.warn("No such resource type: " + (String)object2);
                        bl2 = true;
                        continue;
                    }
                    String string4 = object32.getAttributeValue(ATTR_PATH);
                    String string5 = object32.getAttributeValue(ATTR_URL);
                    String string6 = object32.getAttributeValue(ATTR_CONTENT_HASH);
                    String string7 = object32.getAttributeValue(ATTR_CHARSET);
                    Charset charset = string7 == null ? WebSiteResource.DEFAULT_CHARSET : CharsetHelper.getCharsetFromName(string7);
                    WebSiteResource webSiteResource = new WebSiteResource(eWebSiteResourceType, string4, charset);
                    if (!webSiteResource.isExisting()) {
                        LOGGER.info("Skipping resource bundle '" + string + "' skipping because resource '" + string4 + "' does not exist");
                        bl2 = true;
                        continue;
                    }
                    if (!webSiteResource.getContentHashAsString().equals(string6)) {
                        LOGGER.info("Skipping resource bundle '" + string + "' skipping because resource '" + string4 + "' changed (hash mismatch)");
                        bl2 = true;
                        continue;
                    }
                    commonsArrayList.add(new WebSiteResourceWithCondition(webSiteResource, string2, bl3, cSSMediaList));
                }
            }
            if (bl2) {
                bl = true;
                continue;
            }
            WebSiteResourceBundle webSiteResourceBundle = new WebSiteResourceBundle(commonsArrayList, string2, bl3, cSSMediaList);
            object32 = new WebSiteResourceBundleSerialized(string, webSiteResourceBundle, localDateTime);
            this.m_aMapToData.put(webSiteResourceBundle, string);
            this.m_aMapToBundle.put(string, object32);
        }
        File file = WebFileIO.getDataIO().getFile("resource-bundles/");
        for (File file2 : new FileSystemIterator(file)) {
            if (this.containsResourceBundleOfID(file2.getName()) || !FileOperationManager.INSTANCE.deleteFile(file2).isSuccess()) continue;
            LOGGER.info("Successfully deleted the unused resource bundle file " + file2.getAbsolutePath());
        }
        LOGGER.info("Successfully read " + this.m_aMapToBundle.size() + " resource bundles");
        return bl ? EChange.CHANGED : EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_RESOURCE_BUNDLES);
        for (WebSiteResourceBundleSerialized webSiteResourceBundleSerialized : this.m_aMapToBundle.getSortedByKey(Comparator.naturalOrder()).values()) {
            IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_RESOURCE_BUNDLE);
            iMicroElement2.setAttribute(ATTR_ID, webSiteResourceBundleSerialized.getBundleID());
            iMicroElement2.setAttributeWithConversion(ATTR_CREATIONDT, (Object)webSiteResourceBundleSerialized.getCreationDT());
            WebSiteResourceBundle webSiteResourceBundle = webSiteResourceBundleSerialized.getBundle();
            iMicroElement2.setAttribute(ATTR_CONDITIONAL_COMMENT, webSiteResourceBundle.getConditionalComment());
            iMicroElement2.setAttribute(ATTR_IS_BUNDLABLE, Boolean.toString(webSiteResourceBundle.isBundlable()));
            if (webSiteResourceBundle.hasMediaList()) {
                for (ECSSMedium eCSSMedium : webSiteResourceBundle.getMediaList().getAllMedia()) {
                    iMicroElement2.appendElement(ELEMENT_MEDIUM).appendText(eCSSMedium.getName());
                }
            }
            for (WebSiteResource webSiteResource : webSiteResourceBundle.getAllResources()) {
                IMicroElement iMicroElement3 = iMicroElement2.appendElement(ELEMENT_RESOURCE);
                iMicroElement3.setAttribute(ATTR_RESOURCE_TYPE, webSiteResource.getResourceType().getID());
                iMicroElement3.setAttribute(ATTR_PATH, webSiteResource.getPath());
                iMicroElement3.setAttribute(ATTR_URL, webSiteResource.getAsURLString());
                iMicroElement3.setAttribute(ATTR_CONTENT_HASH, webSiteResource.getContentHashAsString());
                iMicroElement3.setAttribute(ATTR_CHARSET, webSiteResource.getCharset().name());
            }
        }
        return microDocument;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, WebSiteResourceBundleSerialized> getAllResourceBundles() {
        return this.m_aRWLock.readLockedGet(this.m_aMapToBundle::getClone);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WebSiteResourceBundleSerialized> getAllResourceBundlesSerialized() {
        return this.m_aRWLock.readLockedGet(this.m_aMapToBundle::copyOfValues);
    }

    @Nullable
    public WebSiteResourceBundleSerialized getResourceBundleOfID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> (WebSiteResourceBundleSerialized)this.m_aMapToBundle.get(string));
    }

    public boolean containsResourceBundleOfID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMapToBundle.containsKey(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<WebSiteResourceBundleSerialized> getResourceBundles(@Nonnull @Nonempty ICommonsList<WebSiteResourceWithCondition> iCommonsList, boolean bl) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "List");
        CommonsArrayList<WebSiteResourceBundleSerialized> commonsArrayList = new CommonsArrayList<WebSiteResourceBundleSerialized>();
        boolean bl2 = false;
        CommonsArrayList<ICommonsList<WebSiteResourceWithCondition>> commonsArrayList2 = new CommonsArrayList<ICommonsList<WebSiteResourceWithCondition>>(iCommonsList);
        while (commonsArrayList2.isNotEmpty()) {
            WebSiteResourceBundleSerialized webSiteResourceBundleSerialized;
            String string;
            Object object;
            WebSiteResourceWithCondition webSiteResourceWithCondition = (WebSiteResourceWithCondition)commonsArrayList2.removeFirst();
            CommonsArrayList<WebSiteResourceWithCondition> commonsArrayList3 = new CommonsArrayList<WebSiteResourceWithCondition>(webSiteResourceWithCondition);
            while (commonsArrayList2.isNotEmpty() && webSiteResourceWithCondition.canBeBundledWith((WebSiteResourceWithCondition)(object = (WebSiteResourceWithCondition)commonsArrayList2.getFirst()))) {
                commonsArrayList3.add(object);
                commonsArrayList2.removeFirst();
            }
            object = new WebSiteResourceBundle(commonsArrayList3, webSiteResourceWithCondition.getConditionalComment(), commonsArrayList3.size() != 1 || webSiteResourceWithCondition.isBundlable(), webSiteResourceWithCondition.getMediaList());
            this.m_aRWLock.readLock().lock();
            try {
                string = (String)this.m_aMapToData.get(object);
                webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)this.m_aMapToBundle.get(string);
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
            if (webSiteResourceBundleSerialized == null) {
                this.m_aRWLock.writeLock().lock();
                try {
                    string = (String)this.m_aMapToData.get(object);
                    if (string == null) {
                        string = GlobalIDFactory.getNewPersistentStringID();
                        this.m_aMapToData.put(object, string);
                        webSiteResourceBundleSerialized = new WebSiteResourceBundleSerialized(string, (WebSiteResourceBundle)object, bl);
                        this.m_aMapToBundle.put(string, webSiteResourceBundleSerialized);
                        bl2 = true;
                    } else {
                        webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)this.m_aMapToBundle.get(string);
                    }
                }
                finally {
                    this.m_aRWLock.writeLock().unlock();
                }
            }
            commonsArrayList.add(webSiteResourceBundleSerialized);
        }
        if (bl2) {
            this.m_aRWLock.writeLocked(() -> this.markAsChanged());
        }
        return commonsArrayList;
    }
}

