/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.resource.WebSiteResource;
import com.helger.photon.app.resource.WebSiteResourceBundle;
import com.helger.photon.app.url.LinkHelper;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSiteResourceBundleSerialized
implements IHasInputStream {
    public static final String RESOURCE_BUNDLE_PATH = "resource-bundles/";
    public static final Charset CHARSET_TO_USE = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResourceBundleSerialized.class);
    private final String m_sBundleID;
    private final WebSiteResourceBundle m_aBundle;
    private final LocalDateTime m_aCreationDT;

    public WebSiteResourceBundleSerialized(@Nonnull @Nonempty String string, @Nonnull WebSiteResourceBundle webSiteResourceBundle, boolean bl) {
        this(string, webSiteResourceBundle, PDTFactory.getCurrentLocalDateTime());
        this._ensureSerialized(bl);
    }

    WebSiteResourceBundleSerialized(@Nonnull @Nonempty String string, @Nonnull WebSiteResourceBundle webSiteResourceBundle, @Nonnull LocalDateTime localDateTime) {
        this.m_sBundleID = ValueEnforcer.notEmpty(string, "BundleID");
        this.m_aBundle = ValueEnforcer.notNull(webSiteResourceBundle, "Bundle");
        this.m_aCreationDT = ValueEnforcer.notNull(localDateTime, "CreationDT");
    }

    private void _ensureSerialized(boolean bl) {
        FileSystemResource fileSystemResource = WebSiteResourceBundleSerialized.getResource(this.m_sBundleID);
        if (!fileSystemResource.exists()) {
            try (Writer writer = StreamHelper.getBuffered(fileSystemResource.getWriter(StandardCharsets.UTF_8, EAppend.TRUNCATE));){
                if (writer == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("Failed to serialize " + this.m_aBundle.getResourceType().getID() + " bundle '" + this.m_sBundleID + "' with " + this.m_aBundle.getAllResourcePaths() + (this.m_aBundle.hasConditionalComment() ? " and conditional comment '" + this.m_aBundle.getConditionalComment() + "'" : "") + " to path " + fileSystemResource.getAsFile().getAbsolutePath());
                    }
                } else {
                    String string;
                    for (WebSiteResource webSiteResource : this.m_aBundle.getAllResources()) {
                        string = "/* " + webSiteResource.getPath() + " - " + webSiteResource.getResource().getAsURL() + " - " + webSiteResource.getContentHashAsString() + " */\n";
                        writer.write(string);
                    }
                    for (WebSiteResource webSiteResource : this.m_aBundle.getAllResources()) {
                        string = webSiteResource.getContent(bl);
                        if (string != null) {
                            writer.write(string);
                            if (StringHelper.getLastChar(string) == '\n') continue;
                            writer.write(10);
                            continue;
                        }
                        if (!LOGGER.isErrorEnabled()) continue;
                        LOGGER.error("Web site resource '" + webSiteResource.getPath() + "' at '" + webSiteResource.getAsURLString() + "' has no content/does not exist!");
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Serialized " + this.m_aBundle.getResourceType().getID() + " bundle '" + this.m_sBundleID + "' with " + this.m_aBundle.getAllResourcePaths() + (this.m_aBundle.hasConditionalComment() ? " and conditional comment '" + this.m_aBundle.getConditionalComment() + "'" : ""));
                    }
                }
            }
            catch (Throwable throwable) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Error serializing bundle '" + this.m_sBundleID + "' with " + this.m_aBundle.getAllResourcePaths(), throwable);
                }
                throw new IllegalStateException(throwable);
            }
        }
    }

    @Nonnull
    @Nonempty
    public String getBundleID() {
        return this.m_sBundleID;
    }

    @Nonnull
    public WebSiteResourceBundle getBundle() {
        return this.m_aBundle;
    }

    @Nullable
    public static FileSystemResource getResource(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "BundleID");
        return WebFileIO.getDataIO().getResource(RESOURCE_BUNDLE_PATH + string);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return WebSiteResourceBundleSerialized.getResource(this.m_sBundleID).getInputStream();
    }

    @Override
    public boolean isReadMultiple() {
        return true;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aBundle.getMimeType();
    }

    @Nonnull
    public LocalDateTime getCreationDT() {
        return this.m_aCreationDT;
    }

    @Nonnull
    public IHCNode createNode(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        Object object;
        ISimpleURL iSimpleURL = null;
        if (this.m_aBundle.getResourceCount() == 1 && !this.m_aBundle.isBundlable()) {
            object = this.m_aBundle.getResourceAtIndex(0);
            iSimpleURL = ((WebSiteResource)object).getAsURL(iRequestWebScopeWithoutResponse);
        }
        if (iSimpleURL == null) {
            iSimpleURL = LinkHelper.getURLWithContext(iRequestWebScopeWithoutResponse, PhotonAppSettings.getResourceBundleServletName() + "/" + this.m_sBundleID + this.m_aBundle.getResourceType().getFileExtension());
        }
        object = this.m_aBundle.getResourceType().createNode(iSimpleURL, this.m_aBundle.getMediaList());
        return this.m_aBundle.getWrapped((IHCNode)object);
    }

    public String toString() {
        return new ToStringGenerator(this).append("BundleID", this.m_sBundleID).append("Bundle", this.m_aBundle).append("CreationDT", this.m_aCreationDT).getToString();
    }
}

