/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.state.EChange;
import com.helger.photon.app.resource.EWebSiteResourceType;
import com.helger.photon.app.resource.WebSiteResource;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class WebSiteResourceCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSiteResourceCache.class);
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bCacheEnabled = !GlobalDebug.isDebugMode();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, WebSiteResource> s_aMap = new CommonsHashMap<String, WebSiteResource>();
    private static final WebSiteResourceCache s_aInstance = new WebSiteResourceCache();

    private WebSiteResourceCache() {
    }

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    public static boolean isCacheEnabled() {
        return s_aRWLock.readLockedBoolean(() -> s_bCacheEnabled);
    }

    public static void setCacheEnabled(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bCacheEnabled = bl;
            return s_bCacheEnabled;
        });
        if (!WebSiteResourceCache.isSilentMode()) {
            LOGGER.info("WebSiteResourceCache is now: " + (bl ? "enabled" : "disabled"));
        }
    }

    @Nonnull
    public static WebSiteResource getOrCreateResource(@Nonnull EWebSiteResourceType eWebSiteResourceType, @Nonnull @Nonempty String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(eWebSiteResourceType, "ResourceType");
        ValueEnforcer.notEmpty(string, "Path");
        ValueEnforcer.notNull(charset, "Charset");
        if (!WebSiteResourceCache.isCacheEnabled()) {
            WebSiteResource webSiteResource = new WebSiteResource(eWebSiteResourceType, string, charset);
            if (!webSiteResource.isExisting()) {
                throw new IllegalArgumentException("WebSiteResource '" + string + "' of type " + eWebSiteResourceType + " does not exist");
            }
            return webSiteResource;
        }
        String string2 = eWebSiteResourceType.getID() + "-" + string;
        WebSiteResource webSiteResource = s_aRWLock.readLockedGet(() -> (WebSiteResource)s_aMap.get(string2));
        if (webSiteResource != null) {
            return webSiteResource;
        }
        return s_aRWLock.writeLockedGet(() -> s_aMap.computeIfAbsent(string2, string2 -> new WebSiteResource(eWebSiteResourceType, string, charset)));
    }

    @Nonnull
    public static EChange removeFromCache(@Nonnull EWebSiteResourceType eWebSiteResourceType, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(eWebSiteResourceType, "Type");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = eWebSiteResourceType.getID() + "-" + string;
        return s_aRWLock.writeLockedGet(() -> s_aMap.removeObject(string2));
    }

    @Nonnull
    public static EChange clearCache() {
        return s_aRWLock.writeLockedGet(s_aMap::removeAll);
    }
}

