/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.SimpleURL;
import com.helger.commons.url.URLHelper;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.url.IWebURIToURLConverter;
import com.helger.photon.app.url.LinkHelper;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import javax.annotation.Nonnull;

public class StreamOrLocalURIToURLConverter
implements IWebURIToURLConverter {
    public static final boolean isProjectRelativeURI(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, '/');
    }

    @Override
    @Nonnull
    public IReadableResource getAsResource(@Nonnull @Nonempty String string) {
        return StreamOrLocalURIToURLConverter.getAsResourceStatic(string);
    }

    @Nonnull
    public static IReadableResource getAsResourceStatic(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "URI");
        IReadableResource iReadableResource = LinkHelper.hasKnownProtocol(string) ? new URLResource(URLHelper.getAsURL(string)) : (StreamOrLocalURIToURLConverter.isProjectRelativeURI(string) ? WebFileIO.getServletContextIO().getResource(string.substring(1)) : new ClassPathResource(string));
        return iReadableResource;
    }

    @Override
    @Nonnull
    public SimpleURL getAsURL(@Nonnull @Nonempty String string) {
        return StreamOrLocalURIToURLConverter.getAsURLStatic(string);
    }

    @Nonnull
    public static SimpleURL getAsURLStatic(@Nonnull @Nonempty String string) {
        SimpleURL simpleURL;
        ValueEnforcer.notEmpty(string, "URI");
        if (LinkHelper.hasKnownProtocol(string)) {
            simpleURL = new SimpleURL(string);
        } else if (StreamOrLocalURIToURLConverter.isProjectRelativeURI(string)) {
            simpleURL = LinkHelper.getURLWithContext(string);
        } else {
            String string2 = LinkHelper.getStreamServletPath();
            if (!StringHelper.startsWith((CharSequence)string, '/')) {
                string2 = string2 + '/';
            }
            simpleURL = LinkHelper.getURLWithContext(string2 + string);
        }
        return simpleURL;
    }

    @Override
    @Nonnull
    public SimpleURL getAsURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string) {
        return StreamOrLocalURIToURLConverter.getAsURLStatic(iRequestWebScopeWithoutResponse, string);
    }

    @Nonnull
    public static SimpleURL getAsURLStatic(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(iRequestWebScopeWithoutResponse, "RequestScope");
        ValueEnforcer.notEmpty(string, "URI");
        SimpleURL simpleURL = LinkHelper.hasKnownProtocol(string) ? new SimpleURL(string) : (StreamOrLocalURIToURLConverter.isProjectRelativeURI(string) ? LinkHelper.getURLWithContext(iRequestWebScopeWithoutResponse, string) : LinkHelper.getStreamURL(iRequestWebScopeWithoutResponse, string));
        return simpleURL;
    }
}

