/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.concurrent.collector.ConcurrentCollectorMultiple;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.state.EChange;
import com.helger.photon.audit.AbstractAuditor;
import com.helger.photon.audit.IAuditItem;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AsynchronousAuditor
extends AbstractAuditor {
    private static final ThreadFactory s_aThreadFactory = new BasicThreadFactory.Builder().setNamingPattern("AsyncAuditor").setDaemon(true).build();
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousAuditor.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ConcurrentCollectorMultiple<IAuditItem> m_aCollector;
    private final ExecutorService m_aSenderThreadPool;

    public AsynchronousAuditor(@Nonnull ICurrentUserIDProvider iCurrentUserIDProvider, @Nonnull IConcurrentPerformer<List<IAuditItem>> iConcurrentPerformer) {
        super(iCurrentUserIDProvider);
        ValueEnforcer.notNull(iConcurrentPerformer, "Performer");
        this.m_aCollector = new MyCollector(iConcurrentPerformer);
        this.m_aSenderThreadPool = Executors.newSingleThreadExecutor(s_aThreadFactory);
        this.m_aSenderThreadPool.submit(this.m_aCollector::collect);
    }

    @Override
    protected void handleAuditItem(@Nonnull IAuditItem iAuditItem) {
        ValueEnforcer.notNull(iAuditItem, "AuditItem");
        this.m_aRWLock.writeLockedGet(() -> this.m_aCollector.queueObject(iAuditItem));
    }

    @Nonnegative
    public int getQueueLength() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aCollector.getQueueLength());
    }

    @Nonnull
    public EChange stop() {
        if (this.m_aRWLock.writeLockedBoolean(() -> {
            if (this.m_aSenderThreadPool.isShutdown()) {
                return true;
            }
            this.m_aSenderThreadPool.shutdown();
            this.m_aCollector.stopQueuingNewObjects();
            int n = this.m_aCollector.getQueueLength();
            if (n > 0) {
                LOGGER.info("Stopping auditor queue with " + n + " items");
            }
            return false;
        })) {
            return EChange.UNCHANGED;
        }
        try {
            while (!this.m_aSenderThreadPool.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Error stopping auditor queue", interruptedException);
        }
        return EChange.CHANGED;
    }

    private static final class MyCollector
    extends ConcurrentCollectorMultiple<IAuditItem> {
        public MyCollector(@Nonnull IConcurrentPerformer<List<IAuditItem>> iConcurrentPerformer) {
            this.setPerformer(iConcurrentPerformer);
        }
    }
}

