/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.type.ObjectType;
import com.helger.photon.app.mock.MockCurrentUserIDProvider;
import com.helger.photon.audit.IAuditor;
import com.helger.photon.audit.LoggingAuditor;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AuditHelper {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final IAuditor DEFAULT_AUDITOR;
    private static IAuditor s_aAuditor;

    private AuditHelper() {
    }

    @Nonnull
    public static IAuditor getAuditor() {
        return s_aRWLock.readLockedGet(() -> s_aAuditor);
    }

    public static void setAuditor(@Nonnull IAuditor iAuditor) {
        ValueEnforcer.notNull(iAuditor, "Auditor");
        s_aRWLock.writeLockedGet(() -> {
            s_aAuditor = iAuditor;
            return s_aAuditor;
        });
    }

    public static void setDefaultAuditor() {
        AuditHelper.setAuditor(DEFAULT_AUDITOR);
    }

    public static void onAuditCreateSuccess(@Nonnull ObjectType objectType) {
        AuditHelper.getAuditor().onCreateSuccess(objectType, new Object[0]);
    }

    public static void onAuditCreateSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onCreateSuccess(objectType, objectArray);
    }

    @Deprecated
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditCreateFailure(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditCreateFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onCreateFailure(objectType, objectArray);
    }

    @Deprecated
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditModifySuccess(@Nonnull ObjectType objectType, @Nonnull String string) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditModifySuccess(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onModifySuccess(objectType, string, objectArray);
    }

    @Deprecated
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditModifyFailure(@Nonnull ObjectType objectType, @Nonnull String string) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditModifyFailure(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onModifyFailure(objectType, string, objectArray);
    }

    @Deprecated
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditDeleteSuccess(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditDeleteSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onDeleteSuccess(objectType, objectArray);
    }

    @Deprecated
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditDeleteFailure(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditDeleteFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onDeleteFailure(objectType, objectArray);
    }

    @Deprecated
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditUndeleteSuccess(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditUndeleteSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onUndeleteSuccess(objectType, objectArray);
    }

    @Deprecated
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditUndeleteFailure(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditUndeleteFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onUndeleteFailure(objectType, objectArray);
    }

    public static void onAuditExecuteSuccess(@Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteSuccess(string, objectArray);
    }

    public static void onAuditExecuteFailure(@Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteFailure(string, objectArray);
    }

    public static void onAuditExecuteSuccess(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteSuccess(objectType, string, objectArray);
    }

    public static void onAuditExecuteFailure(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteFailure(objectType, string, objectArray);
    }

    static {
        s_aAuditor = DEFAULT_AUDITOR = new LoggingAuditor((ICurrentUserIDProvider)new MockCurrentUserIDProvider(null), "!DEFAULT-AUDITOR! ");
    }
}

