/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.audit.EAuditActionType;
import com.helger.photon.audit.IAuditItem;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AuditItem
implements IAuditItem {
    private final LocalDateTime m_aDateTime;
    private final String m_sUserID;
    private final EAuditActionType m_eType;
    private final ESuccess m_eSuccess;
    private final String m_sAction;

    public AuditItem(@Nullable String string, @Nonnull EAuditActionType eAuditActionType, @Nonnull ESuccess eSuccess, @Nonnull String string2) {
        this(PDTFactory.getCurrentLocalDateTime(), StringHelper.hasText(string) ? string : "$GUEST$", eAuditActionType, eSuccess, string2);
    }

    AuditItem(@Nonnull LocalDateTime localDateTime, @Nonnull String string, @Nonnull EAuditActionType eAuditActionType, @Nonnull ESuccess eSuccess, @Nonnull String string2) {
        this.m_aDateTime = ValueEnforcer.notNull(localDateTime, "LocalDateTime");
        this.m_sUserID = ValueEnforcer.notEmpty(string, "UserID");
        this.m_eType = ValueEnforcer.notNull(eAuditActionType, "Type");
        this.m_eSuccess = ValueEnforcer.notNull(eSuccess, "Success");
        this.m_sAction = ValueEnforcer.notNull(string2, "Action");
    }

    @Override
    @Nonnull
    public LocalDateTime getDateTime() {
        return this.m_aDateTime;
    }

    @Override
    @Nonnull
    public String getUserID() {
        return this.m_sUserID;
    }

    @Override
    @Nonnull
    public EAuditActionType getType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    public ESuccess getSuccess() {
        return this.m_eSuccess;
    }

    @Override
    @Nonnull
    public String getAction() {
        return this.m_sAction;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuditItem auditItem = (AuditItem)object;
        return this.m_aDateTime.equals(auditItem.m_aDateTime) && this.m_sUserID.equals(auditItem.m_sUserID) && this.m_eType.equals(auditItem.m_eType) && this.m_eSuccess.equals(auditItem.m_eSuccess) && this.m_sAction.equals(auditItem.m_sAction);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aDateTime).append(this.m_sUserID).append((Enum)this.m_eType)).append((Enum)this.m_eSuccess)).append(this.m_sAction).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("dateTime", this.m_aDateTime).append("userID", this.m_sUserID).append("type", this.m_eType).append("success", this.m_eSuccess).append("action", this.m_sAction).getToString();
    }
}

