/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ContainsSoftMigration;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.FileSystemIterator;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.relative.IFileRelativeIO;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.dao.DAOException;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.photon.app.dao.AbstractPhotonSimpleDAO;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.audit.AsynchronousAuditor;
import com.helger.photon.audit.AuditItem;
import com.helger.photon.audit.AuditItemList;
import com.helger.photon.audit.IAuditItem;
import com.helger.photon.audit.IAuditManager;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.File;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AuditManager
extends AbstractPhotonSimpleDAO
implements IAuditManager {
    public static final String ELEMENT_ITEMS = "items";
    public static final String ELEMENT_ITEM = "item";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditManager.class);
    private final String m_sBaseDir;
    private final AuditItemList m_aItems = new AuditItemList();
    private final AsynchronousAuditor m_aAuditor;
    private LocalDate m_aEarliestAuditDate;

    @Nonnull
    @Nonempty
    public static String getRelativeAuditDirectoryYear(@Nonnull int n) {
        return n + "/";
    }

    @Nonnull
    @Nonempty
    public static String getRelativeAuditDirectory(@Nonnull LocalDate localDate) {
        return AuditManager.getRelativeAuditDirectoryYear(localDate.getYear()) + StringHelper.getLeadingZero(localDate.getMonthValue(), 2) + "/";
    }

    @Nonnull
    @Nonempty
    public static String getRelativeAuditFilename(@Nonnull LocalDate localDate) {
        return AuditManager.getRelativeAuditDirectory(localDate) + PDTIOHelper.getDateForFilename(localDate) + ".xml";
    }

    @ContainsSoftMigration
    public AuditManager(@Nullable String string, @Nonnull ICurrentUserIDProvider iCurrentUserIDProvider) throws DAOException {
        super(new AuditHasFilename(string));
        Object object;
        ValueEnforcer.notNull(iCurrentUserIDProvider, "CurrentUserIDProvider");
        this.m_sBaseDir = string;
        if (StringHelper.hasText(string)) {
            object = this.getIO();
            object.createDirectory(string, true);
            if (!object.existsDir(string + PDTFactory.getCurrentYear())) {
                LOGGER.info("Moving audit files");
                int n = 0;
                for (File file : new FileSystemIterator(object.getFile(string))) {
                    if (!file.isFile() || !file.getName().endsWith(".xml")) continue;
                    String string2 = file.getName();
                    String string3 = string + string2.substring(0, 4) + "/" + string2.substring(4, 6);
                    object.createDirectory(string3, true);
                    object.renameFile(string + string2, string3 + "/" + string2);
                    ++n;
                }
                LOGGER.info("Finished moving " + n + " files");
            }
        }
        object = list -> {
            if (!list.isEmpty()) {
                this.m_aRWLock.writeLocked(() -> {
                    for (IAuditItem iAuditItem : list) {
                        this.m_aItems.internalAddItem(iAuditItem);
                    }
                    this.markAsChanged();
                });
            }
        };
        this.m_aAuditor = new AsynchronousAuditor(iCurrentUserIDProvider, (IConcurrentPerformer<List<IAuditItem>>)object);
        this.initialRead();
    }

    @Override
    public boolean isInMemory() {
        return this.m_sBaseDir == null;
    }

    @Override
    @Nullable
    public String getBaseDir() {
        return this.m_sBaseDir;
    }

    @Override
    @Nonnull
    public AsynchronousAuditor getAuditor() {
        return this.m_aAuditor;
    }

    public static void readFromXML(@Nonnull IMicroDocument iMicroDocument, @Nonnull Consumer<? super IAuditItem> consumer) {
        ValueEnforcer.notNull(iMicroDocument, "Doc");
        ValueEnforcer.notNull(consumer, "Handler");
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_ITEM)) {
            AuditItem auditItem = MicroTypeConverter.convertToNative(iMicroElement, AuditItem.class);
            consumer.accept(auditItem);
        }
    }

    @Override
    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        AuditManager.readFromXML(iMicroDocument, iAuditItem -> this.m_aItems.internalAddItem((IAuditItem)iAuditItem));
        return EChange.UNCHANGED;
    }

    @Override
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_ITEMS);
        for (IAuditItem iAuditItem : this.m_aItems.getAllItems()) {
            iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(iAuditItem, ELEMENT_ITEM));
        }
        return microDocument;
    }

    @Override
    protected void onFilenameChange(@Nullable String string, @Nonnull String string2) {
        if (string != null) {
            this.m_aItems.internalKeepOnlyLast();
        }
    }

    @Nonnegative
    public int getAuditItemCount() {
        return this.m_aRWLock.readLockedInt(this.m_aItems::getItemCount);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    @CodingStyleguideUnaware
    public List<IAuditItem> getLastAuditItems(@Nonnegative int n) {
        return this.m_aRWLock.readLockedGet(() -> this.m_aItems.getLastItems(n));
    }

    @Override
    public void stop() {
        this.m_aAuditor.stop();
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<IAuditItem> getAllAuditItemsOfDate(@Nonnull LocalDate localDate) {
        ValueEnforcer.notNull(localDate, "Date");
        String string = this.m_sBaseDir + AuditManager.getRelativeAuditFilename(localDate);
        File file = this.getIO().getFile(string);
        if (!file.exists()) {
            return null;
        }
        CommonsArrayList<IAuditItem> commonsArrayList = new CommonsArrayList<IAuditItem>();
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(file);
        AuditManager.readFromXML(iMicroDocument, commonsArrayList::add);
        return commonsArrayList;
    }

    @Override
    @Nonnull
    public LocalDate getEarliestAuditDate() {
        if (this.m_aEarliestAuditDate == null) {
            LocalDate localDate;
            LocalDate localDate2 = localDate = PDTFactory.getCurrentLocalDate();
            if (!this.isInMemory()) {
                IFileRelativeIO iFileRelativeIO = WebFileIO.getDataIO();
                int n = localDate2.getYear();
                while (iFileRelativeIO.getFile(this.m_sBaseDir + AuditManager.getRelativeAuditDirectoryYear(n)).isDirectory()) {
                    --n;
                }
                localDate2 = LocalDate.of(++n, Month.JANUARY, 1);
                for (Month month : Month.values()) {
                    localDate2 = localDate2.withMonth(month.getValue());
                    if (iFileRelativeIO.getFile(this.m_sBaseDir + AuditManager.getRelativeAuditDirectory(localDate2)).isDirectory()) break;
                }
                while (localDate2.isBefore(localDate)) {
                    localDate2 = localDate2.plusDays(1L);
                    if (!iFileRelativeIO.getFile(this.m_sBaseDir + AuditManager.getRelativeAuditFilename(localDate2)).isFile()) continue;
                }
            }
            this.m_aEarliestAuditDate = localDate2;
        }
        return this.m_aEarliestAuditDate;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AuditManager auditManager = (AuditManager)object;
        return this.m_aItems.equals(auditManager.m_aItems);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aItems).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("BaseDir", this.m_sBaseDir).append("Items", this.m_aItems).append("Auditor", this.m_aAuditor).getToString();
    }

    private static final class AuditHasFilename
    implements ISupplier<String> {
        private final String m_sBaseDir;

        AuditHasFilename(@Nullable String string) {
            ValueEnforcer.isTrue(StringHelper.hasNoText(string) || FilenameHelper.endsWithPathSeparatorChar(string), () -> "BaseDir '" + string + "' must end with path separator!");
            this.m_sBaseDir = string;
        }

        @Override
        @Nullable
        public String get() {
            if (StringHelper.hasNoText(this.m_sBaseDir)) {
                return null;
            }
            return this.m_sBaseDir + AuditManager.getRelativeAuditFilename(PDTFactory.getCurrentLocalDate());
        }
    }
}

