/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.functional.IBiFunction;
import com.helger.commons.string.StringHelper;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.commons.typeconvert.TypeConverterException;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;

@FunctionalInterface
public interface IAuditActionStringProvider
extends IBiFunction<String, Object[], String> {
    public static final IAuditActionStringProvider PLAIN_STRING = (string, objectArray) -> {
        if (ArrayHelper.isEmpty(objectArray)) {
            return string;
        }
        return string + '(' + StringHelper.getImploded(',', objectArray) + ')';
    };
    public static final IAuditActionStringProvider JSON = (string, objectArray) -> {
        IJsonArray iJsonArray = (IJsonArray)new JsonArray().addAll(objectArray);
        return new JsonObject().addJson((String)string, iJsonArray).getAsJsonString();
    };
    public static final IAuditActionStringProvider JSON_WITH_CONVERSION = (string, objectArray) -> {
        JsonArray jsonArray = new JsonArray();
        for (Object object : objectArray) {
            IJson iJson = null;
            try {
                iJson = TypeConverter.convert(object, IJson.class);
            }
            catch (TypeConverterException typeConverterException) {
                // empty catch block
            }
            if (iJson != null) {
                jsonArray.add(iJson);
                continue;
            }
            jsonArray.add(object);
        }
        return new JsonObject().addJson((String)string, jsonArray).getAsJsonString();
    };
}

