/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit.v2.domain;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AuditField
implements Serializable {
    private final String m_sName;
    private final String m_sValue;

    public AuditField(@Nullable String string, @Nullable String string2) {
        this.m_sName = string;
        this.m_sValue = string2;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    public boolean hasName() {
        return StringHelper.hasText(this.m_sName);
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    public boolean hasValue() {
        return StringHelper.hasText(this.m_sValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuditField auditField = (AuditField)object;
        return EqualsHelper.equals(this.m_sName, auditField.m_sName) && EqualsHelper.equals(this.m_sValue, auditField.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sName).append(this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Name", this.m_sName).append("Value", this.m_sValue).getToString();
    }

    @Nonnull
    public static AuditField createWithHiddenValue(@Nullable String string) {
        return new AuditField(string, "****");
    }
}

