/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit.v2.pipeline;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.callback.exception.LoggingExceptionCallback;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.photon.audit.v2.domain.AuditEvent;
import com.helger.photon.audit.v2.pipeline.IAuditEventConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AuditEventConsumerPipeline
implements IAuditEventConsumer {
    private final ICommonsList<IAuditEventConsumer> m_aConsumers = new CommonsArrayList<IAuditEventConsumer>();
    private final CallbackList<IExceptionCallback<? super Exception>> m_aExCallbacks = new CallbackList();

    public AuditEventConsumerPipeline() {
        this.m_aExCallbacks.add(new LoggingExceptionCallback());
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IAuditEventConsumer> consumers() {
        return this.m_aConsumers;
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IExceptionCallback<? super Exception>> exceptionCallbacks() {
        return this.m_aExCallbacks;
    }

    @Override
    public void consumeAuditEvent(@Nonnull AuditEvent auditEvent) {
        for (IAuditEventConsumer iAuditEventConsumer : this.m_aConsumers) {
            try {
                iAuditEventConsumer.consumeAuditEvent(auditEvent);
            }
            catch (Exception exception) {
                this.m_aExCallbacks.forEach((Consumer<IExceptionCallback<? super Exception>>)((Consumer<IExceptionCallback>)iExceptionCallback -> iExceptionCallback.onException(exception)));
            }
        }
    }
}

