/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core;

import com.helger.photon.app.PhotonAppInit;
import com.helger.photon.core.audit.AuditingLongRunningRequestCallback;
import com.helger.photon.core.audit.AuditingParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.RequestTracker;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PhotonCoreInit {
    private static final AtomicBoolean s_aRegisteredRequestTracker = new AtomicBoolean(false);

    private PhotonCoreInit() {
    }

    public static void startUp() {
        PhotonAppInit.startUp();
        if (!s_aRegisteredRequestTracker.getAndSet(true)) {
            RequestTracker.longRunningRequestCallbacks().add(AuditingLongRunningRequestCallback.INSTANCE);
            RequestTracker.parallelRunningRequestCallbacks().add(AuditingParallelRunningRequestCallback.INSTANCE);
        }
    }

    public static void shutdown() {
        if (s_aRegisteredRequestTracker.getAndSet(false)) {
            RequestTracker.longRunningRequestCallbacks().removeObject(AuditingLongRunningRequestCallback.INSTANCE);
            RequestTracker.parallelRunningRequestCallbacks().removeObject(AuditingParallelRunningRequestCallback.INSTANCE);
        }
        PhotonAppInit.shutdown();
    }
}

