/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.ajax.atom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.id.IHasID;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.timing.StopWatch;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.photon.atom.Feed;
import com.helger.photon.atom.FeedGenerator;
import com.helger.photon.atom.FeedLink;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNewsfeedAjaxExecutor
implements IAjaxExecutor,
IHasID<String>,
IHasDisplayText {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNewsfeedAjaxExecutor.class);
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsHdlExecute = StatisticsManager.getKeyedCounterHandler(AbstractNewsfeedAjaxExecutor.class.getName() + "$EXECUTE");
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsHdlError = StatisticsManager.getKeyedCounterHandler(AbstractNewsfeedAjaxExecutor.class.getName() + "$ERROR");
    private final IHasDisplayText m_aDisplayText;
    private final String m_sFeedID;

    public AbstractNewsfeedAjaxExecutor(@Nonnull IHasDisplayText iHasDisplayText, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(iHasDisplayText, "DisplayText");
        ValueEnforcer.notNull(string, "FeedID");
        this.m_aDisplayText = iHasDisplayText;
        this.m_sFeedID = string;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sFeedID;
    }

    @Override
    public final String getDisplayText(@Nonnull Locale locale) {
        return this.m_aDisplayText.getDisplayText(locale);
    }

    @Nonnull
    @OverrideOnDemand
    protected String getFeedDescription() {
        return "ph-oton-core";
    }

    protected abstract void fillNewsfeed(@Nonnull Feed var1);

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        StopWatch stopWatch = StopWatch.createdStarted();
        s_aStatsHdlExecute.increment(this.m_sFeedID);
        Feed feed = new Feed();
        feed.setID("urn:ph-oton-core:newsfeed:" + this.m_sFeedID);
        FeedGenerator feedGenerator = new FeedGenerator("urn:ph-oton-core");
        feedGenerator.setDescription(this.getFeedDescription());
        feed.setGenerator(feedGenerator);
        feed.addLink(new FeedLink(iRequestWebScopeWithoutResponse.getFullContextAndServletPath() + this.m_sFeedID, "self"));
        this.fillNewsfeed(feed);
        if (!feed.isValid()) {
            LOGGER.error("Created newsfeed with ID '" + this.m_sFeedID + "' is invalid!");
            s_aStatsHdlError.increment(this.m_sFeedID);
        }
        LocalDateTime localDateTime = feed.getUpdated() != null ? feed.getUpdated().getDateTime() : null;
        StatisticsManager.getTimerHandler(AbstractNewsfeedAjaxExecutor.class.getName() + "$TIMER." + this.m_sFeedID).addTime(stopWatch.stopAndGetMillis());
        photonUnifiedResponse.xml(feed.getAsDocument());
        photonUnifiedResponse.setMimeType(CMimeType.APPLICATION_ATOM_XML);
        if (localDateTime != null) {
            photonUnifiedResponse.setLastModified(localDateTime);
        }
    }
}

