/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.photon.core.appid.PhotonGlobalStatePerApp;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhotonGlobalState
extends AbstractGlobalWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonGlobalState.class);
    private String m_sDefaultApplicationID;
    private final ICommonsMap<String, PhotonGlobalStatePerApp> m_aStateMap = new CommonsHashMap<String, PhotonGlobalStatePerApp>();

    @Deprecated
    @UsedViaReflection
    public PhotonGlobalState() {
    }

    @Nonnull
    public static PhotonGlobalState getInstance() {
        return PhotonGlobalState.getGlobalSingleton(PhotonGlobalState.class);
    }

    @Nullable
    public String getDefaultApplicationID() {
        return this.m_aRWLock.readLockedGet(() -> this.m_sDefaultApplicationID);
    }

    public boolean hasDefaultApplicationID() {
        return StringHelper.hasText(this.getDefaultApplicationID());
    }

    @Nonnull
    public PhotonGlobalState setDefaultApplicationID(@Nullable String string) {
        this.m_aRWLock.writeLocked(() -> {
            if (!EqualsHelper.equals(this.m_sDefaultApplicationID, string)) {
                this.m_sDefaultApplicationID = string;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Default application ID set to '" + string + "'");
                }
            }
        });
        return this;
    }

    @Nonnull
    public static PhotonGlobalStatePerApp state(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "AppID");
        PhotonGlobalState photonGlobalState = PhotonGlobalState.getInstance();
        return photonGlobalState.m_aStateMap.computeIfAbsent(string, string2 -> {
            if (!photonGlobalState.hasDefaultApplicationID()) {
                photonGlobalState.setDefaultApplicationID(string);
            }
            return new PhotonGlobalStatePerApp();
        });
    }

    public static void clear() {
        PhotonGlobalState photonGlobalState = PhotonGlobalState.getInstance();
        photonGlobalState.m_aStateMap.clear();
        photonGlobalState.setDefaultApplicationID(null);
    }

    public static void removeAllApplicationServletPathMappings() {
        PhotonGlobalState.getInstance().m_aStateMap.forEachValue(PhotonGlobalStatePerApp::removeServletPath);
    }

    public static boolean containsNoState() {
        return PhotonGlobalState.getInstance().m_aStateMap.isEmpty();
    }

    public static boolean containsAnyApplicationServletPathMapping() {
        return PhotonGlobalState.getInstance().m_aStateMap.containsAnyValue(photonGlobalStatePerApp -> photonGlobalStatePerApp.internalGetServletPath() != null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> getAppIDToServletPathMap() {
        CommonsHashMap<String, String> commonsHashMap = new CommonsHashMap<String, String>();
        PhotonGlobalState.getInstance().m_aStateMap.forEach((string, photonGlobalStatePerApp) -> commonsHashMap.put(string, photonGlobalStatePerApp.getServletPath()));
        return commonsHashMap;
    }
}

