/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.menu.IMenuTree;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PhotonGlobalStatePerApp
implements Serializable {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private String m_sServletPath;
    @GuardedBy(value="m_aRWLock")
    private IMenuTree m_aMenuTree;

    @Nullable
    String internalGetServletPath() {
        return this.m_aRWLock.readLockedGet(() -> this.m_sServletPath);
    }

    @Nonnull
    @Nonempty
    public String getServletPath() throws IllegalStateException {
        String string = this.internalGetServletPath();
        if (StringHelper.hasNoText(string)) {
            throw new IllegalStateException("No servlet path specified!");
        }
        return string;
    }

    @Nonnull
    public PhotonGlobalStatePerApp setServletPath(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "ApplicationServletPath");
        ValueEnforcer.isTrue(StringHelper.startsWith((CharSequence)string, '/'), "ApplicationServletPath must start with a slash");
        ValueEnforcer.isFalse(StringHelper.endsWith((CharSequence)string, '/'), "ApplicationServletPath must end with a slash");
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_sServletPath = string;
            return this.m_sServletPath;
        });
        return this;
    }

    @Nonnull
    public PhotonGlobalStatePerApp removeServletPath() {
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_sServletPath = null;
            return null;
        });
        return this;
    }

    @Nullable
    public IMenuTree getMenuTree() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aMenuTree);
    }

    @Nonnull
    public PhotonGlobalStatePerApp setMenuTree(@Nullable IMenuTree iMenuTree) {
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aMenuTree = iMenuTree;
            return this.m_aMenuTree;
        });
        return this;
    }

    public String toString() {
        return new ToStringGenerator(null).append("ServletPath", this.m_sServletPath).append("MenuTree", this.m_aMenuTree).getToString();
    }
}

