/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.appid.PhotonGlobalStatePerApp;
import com.helger.photon.core.appid.PhotonSessionStatePerApp;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuTree;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PhotonRequestState
implements Serializable {
    private final IMenuTree m_aMenuTree;
    private final IMenuItemPage m_aMenuItem;
    private final Locale m_aDisplayLocale;

    public PhotonRequestState(@Nonnull PhotonSessionStatePerApp photonSessionStatePerApp) {
        this(photonSessionStatePerApp.getMenuTree(), photonSessionStatePerApp.getMenuItem(), photonSessionStatePerApp.getDisplayLocale());
    }

    public PhotonRequestState(@Nonnull PhotonGlobalStatePerApp photonGlobalStatePerApp) {
        this(photonGlobalStatePerApp.getMenuTree(), photonGlobalStatePerApp.getMenuTree() == null ? null : photonGlobalStatePerApp.getMenuTree().getDefaultMenuItem(), GlobalLocaleManager.getInstance().getDefaultLocale());
    }

    public PhotonRequestState(@Nullable IMenuTree iMenuTree, @Nullable IMenuItemPage iMenuItemPage, @Nonnull Locale locale) {
        this.m_aMenuTree = iMenuTree;
        this.m_aMenuItem = iMenuItemPage;
        this.m_aDisplayLocale = ValueEnforcer.notNull(locale, "DisplayLocale");
    }

    @Nullable
    public IMenuTree getMenuTree() {
        return this.m_aMenuTree;
    }

    @Nullable
    public IMenuItemPage getMenuItem() {
        return this.m_aMenuItem;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    public String toString() {
        return new ToStringGenerator(null).append("MenuTree", this.m_aMenuTree).append("MenuItem", this.m_aMenuItem).append("DisplayLocale", this.m_aDisplayLocale).getToString();
    }
}

