/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.appid.PhotonSessionStatePerApp;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PhotonSessionState
extends AbstractSessionWebSingleton {
    @GuardedBy(value="s_aRWLock")
    private String m_sLastApplicationID;
    private final ICommonsMap<String, PhotonSessionStatePerApp> m_aStateMap = new CommonsHashMap<String, PhotonSessionStatePerApp>();

    @Deprecated
    @UsedViaReflection
    public PhotonSessionState() {
    }

    @Nonnull
    public static PhotonSessionState getInstance() {
        return PhotonSessionState.getSessionSingleton(PhotonSessionState.class);
    }

    @Nullable
    public static PhotonSessionState getInstanceIfInstantiated() {
        return PhotonSessionState.getSessionSingletonIfInstantiated(PhotonSessionState.class);
    }

    @Nullable
    public String getLastApplicationID() {
        return this.m_aRWLock.readLockedGet(() -> this.m_sLastApplicationID);
    }

    void setLastApplicationID(@Nullable String string) {
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_sLastApplicationID = string;
            return this.m_sLastApplicationID;
        });
    }

    @Nonnull
    public PhotonSessionStatePerApp state(@Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string2, "AppID");
        return this.m_aStateMap.computeIfAbsent(string2, string -> new PhotonSessionStatePerApp());
    }

    @Nonnull
    public PhotonSessionStatePerApp stateLastAppID() {
        return this.state(this.getLastApplicationID());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("LastApplicationID", this.m_sLastApplicationID).append("StateMap", this.m_aStateMap).getToString();
    }
}

