/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuTree;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PhotonSessionStatePerApp
implements Serializable {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private IMenuTree m_aMenuTree;
    private IMenuItemPage m_aMenuItem;
    private Locale m_aDisplayLocale;

    @Nullable
    public IMenuTree getMenuTree() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aMenuTree);
    }

    @Nonnull
    public PhotonSessionStatePerApp setMenuTree(@Nullable IMenuTree iMenuTree) {
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aMenuTree = iMenuTree;
            return this.m_aMenuTree;
        });
        return this;
    }

    @Nullable
    public IMenuItemPage getMenuItem() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aMenuItem);
    }

    @Nonnull
    public PhotonSessionStatePerApp setMenuItem(@Nullable IMenuItemPage iMenuItemPage) {
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aMenuItem = iMenuItemPage;
            return this.m_aMenuItem;
        });
        return this;
    }

    @Nullable
    public Locale getDisplayLocale() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aDisplayLocale);
    }

    @Nonnull
    public PhotonSessionStatePerApp setDisplayLocale(@Nullable Locale locale) {
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aDisplayLocale = locale;
            return this.m_aDisplayLocale;
        });
        return this;
    }

    public boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMenuTree != null || this.m_aMenuItem != null || this.m_aDisplayLocale != null);
    }

    public String toString() {
        return new ToStringGenerator(null).append("MenuTree", this.m_aMenuTree).append("MenuItem", this.m_aMenuItem).append("DisplayLocale", this.m_aDisplayLocale).getToString();
    }
}

