/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.attr.IAttributeContainerAny;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.string.StringHelper;
import com.helger.photon.core.appid.PhotonGlobalState;
import com.helger.photon.core.appid.PhotonRequestState;
import com.helger.photon.core.appid.PhotonSessionState;
import com.helger.photon.core.appid.PhotonSessionStatePerApp;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RequestSettings {
    public static final String REQUEST_ATTR_APP_ID = "$ph-app-id";
    public static final String REQUEST_ATTR_STATE = "$ph-app-state";

    private RequestSettings() {
    }

    @Nullable
    private static String _getApplicationIDOrNull(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string = (String)iRequestWebScopeWithoutResponse.attrs().getCastedValue(REQUEST_ATTR_APP_ID);
        if (StringHelper.hasNoText(string)) {
            PhotonSessionState photonSessionState = PhotonSessionState.getInstanceIfInstantiated();
            if (photonSessionState != null) {
                string = photonSessionState.getLastApplicationID();
            }
            if (StringHelper.hasNoText(string)) {
                string = PhotonGlobalState.getInstance().getDefaultApplicationID();
            }
        }
        return string;
    }

    @Nonnull
    @Nonempty
    public static String getApplicationID(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string = RequestSettings._getApplicationIDOrNull(iRequestWebScopeWithoutResponse);
        if (StringHelper.hasNoText(string)) {
            throw new IllegalStateException("No app ID is present!");
        }
        return string;
    }

    @Nullable
    private static PhotonRequestState _getRequestStateOrNull(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string;
        PhotonRequestState photonRequestState = (PhotonRequestState)iRequestWebScopeWithoutResponse.attrs().getCastedValue(REQUEST_ATTR_STATE);
        if (photonRequestState == null && StringHelper.hasText(string = RequestSettings._getApplicationIDOrNull(iRequestWebScopeWithoutResponse))) {
            PhotonSessionStatePerApp photonSessionStatePerApp;
            PhotonSessionState photonSessionState = PhotonSessionState.getInstanceIfInstantiated();
            if (photonSessionState != null && (photonSessionStatePerApp = photonSessionState.state(string)).isNotEmpty()) {
                photonRequestState = new PhotonRequestState(photonSessionStatePerApp);
            }
            if (photonRequestState == null) {
                photonRequestState = new PhotonRequestState(PhotonGlobalState.state(string));
            }
        }
        return photonRequestState;
    }

    @Nonnull
    public static PhotonRequestState getRequestState(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        PhotonRequestState photonRequestState = RequestSettings._getRequestStateOrNull(iRequestWebScopeWithoutResponse);
        if (photonRequestState == null) {
            throw new IllegalStateException("No state is present!");
        }
        return photonRequestState;
    }

    @Nonnull
    public static IMenuTree getMenuTree(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        IMenuTree iMenuTree = RequestSettings.getRequestState(iRequestWebScopeWithoutResponse).getMenuTree();
        if (iMenuTree == null) {
            throw new IllegalStateException("No menu tree is present!");
        }
        return iMenuTree;
    }

    @Nonnull
    public static IMenuItemPage getMenuItem(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        IMenuItemPage iMenuItemPage = RequestSettings.getRequestState(iRequestWebScopeWithoutResponse).getMenuItem();
        if (iMenuItemPage == null) {
            throw new IllegalStateException("No menu item is present!");
        }
        return iMenuItemPage;
    }

    @Nonnull
    @Nonempty
    public static String getMenuItemID(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return (String)RequestSettings.getMenuItem(iRequestWebScopeWithoutResponse).getID();
    }

    @Nonnull
    public static Locale getDisplayLocale(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        Locale locale = RequestSettings.getRequestState(iRequestWebScopeWithoutResponse).getDisplayLocale();
        if (locale == null) {
            throw new IllegalStateException("No locale is available");
        }
        return locale;
    }

    @Nonnull
    public static Locale getDisplayCountry(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return CountryCache.getInstance().getCountry(RequestSettings.getDisplayLocale(iRequestWebScopeWithoutResponse));
    }

    @Nonnull
    public static String getDisplayLanguage(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return RequestSettings.getDisplayLocale(iRequestWebScopeWithoutResponse).getLanguage();
    }

    static void setRequestState(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull @Nonempty String string, @Nonnull PhotonRequestState photonRequestState) {
        ValueEnforcer.notEmpty(string, "AppID");
        ValueEnforcer.notNull(photonRequestState, "State");
        IAttributeContainerAny<String> iAttributeContainerAny = iRequestWebScopeWithoutResponse.attrs();
        iAttributeContainerAny.putIn(REQUEST_ATTR_APP_ID, string);
        iAttributeContainerAny.putIn(REQUEST_ATTR_STATE, photonRequestState);
    }
}

