/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.photon.core.appid.PhotonGlobalState;
import com.helger.photon.core.appid.PhotonGlobalStatePerApp;
import com.helger.photon.core.appid.PhotonRequestState;
import com.helger.photon.core.appid.PhotonSessionState;
import com.helger.photon.core.appid.PhotonSessionStatePerApp;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.photon.core.locale.GlobalLocaleManager;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.requestparam.PhotonRequestParameters;
import com.helger.photon.core.requestparam.RequestParameterManager;
import com.helger.tree.withid.BasicTreeItemWithID;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.filter.IXServletHighLevelFilter;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class XServletFilterAppIDExplicit
implements IXServletHighLevelFilter {
    private final String m_sAppID;

    public XServletFilterAppIDExplicit(@Nonnull @Nonempty String string) {
        this.m_sAppID = ValueEnforcer.notEmpty(string, "AppID");
    }

    public static void setStatePerApp(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        Object object;
        Object object2;
        PhotonSessionState photonSessionState = PhotonSessionState.getInstance();
        photonSessionState.setLastApplicationID(string);
        PhotonSessionStatePerApp photonSessionStatePerApp = photonSessionState.state(string);
        PhotonGlobalStatePerApp photonGlobalStatePerApp = PhotonGlobalState.state(string);
        IMenuTree iMenuTree = photonSessionStatePerApp.getMenuTree();
        if (iMenuTree == null && (iMenuTree = photonGlobalStatePerApp.getMenuTree()) != null) {
            photonSessionStatePerApp.setMenuTree(iMenuTree);
        }
        if (iMenuTree == null) {
            throw new IllegalStateException("Failed to resolve MenuTree for request using application ID '" + string + "'!");
        }
        PhotonRequestParameters photonRequestParameters = RequestParameterManager.getInstance().getParameterHandler().getParametersFromRequest(iRequestWebScopeWithoutResponse, iMenuTree);
        Serializable serializable = photonRequestParameters.getMenuItem();
        if (serializable == null && (serializable = photonSessionStatePerApp.getMenuItem()) == null) {
            IMenuItemPage iMenuItemPage;
            object2 = iMenuTree.getDefaultMenuItem();
            if (object2 != null && object2.matchesDisplayFilter()) {
                serializable = object2;
            }
            if (serializable == null && ((BasicTreeItemWithID)(object = (DefaultTreeItemWithID)iMenuTree.getRootItem())).hasChildren() && (iMenuItemPage = ((BasicTreeItemWithID)object).findFirstChildMapped(defaultTreeItemWithID -> defaultTreeItemWithID.getData() instanceof IMenuItemPage && ((IMenuObject)defaultTreeItemWithID.getData()).matchesDisplayFilter(), defaultTreeItemWithID -> (IMenuItemPage)defaultTreeItemWithID.getData())) != null) {
                serializable = iMenuItemPage;
            }
        }
        if (serializable == null) {
            throw new IllegalStateException("No menu item is present for application ID '" + string + "'!");
        }
        photonSessionStatePerApp.setMenuItem((IMenuItemPage)serializable);
        object2 = photonRequestParameters.getLocale();
        if (object2 == null) {
            object = photonSessionStatePerApp.getDisplayLocale();
            if (object != null) {
                object2 = object;
            }
            if (object2 == null && (object2 = GlobalLocaleManager.getInstance().getDefaultLocale()) == null) {
                throw new IllegalStateException("No locale could be determined for application ID '" + string + "!");
            }
        }
        photonSessionStatePerApp.setDisplayLocale((Locale)object2);
        RequestSettings.setRequestState(iRequestWebScopeWithoutResponse, string, new PhotonRequestState(iMenuTree, (IMenuItemPage)serializable, (Locale)object2));
    }

    @Override
    public void beforeRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        XServletFilterAppIDExplicit.setStatePerApp(iRequestWebScope, this.m_sAppID);
    }

    @Override
    public void afterRequest(@Nonnull IRequestWebScope iRequestWebScope) {
    }
}

