/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.appid;

import com.helger.commons.string.StringHelper;
import com.helger.photon.core.appid.PhotonGlobalState;
import com.helger.photon.core.appid.PhotonRequestState;
import com.helger.photon.core.appid.PhotonSessionState;
import com.helger.photon.core.appid.PhotonSessionStatePerApp;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.filter.IXServletHighLevelFilter;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XServletFilterAppIDFromSessionID
implements IXServletHighLevelFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletFilterAppIDFromSessionID.class);

    public static void setStatePerApp(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        PhotonSessionState photonSessionState = PhotonSessionState.getInstanceIfInstantiated();
        String string = null;
        if (photonSessionState != null) {
            string = photonSessionState.getLastApplicationID();
        }
        if (StringHelper.hasNoText(string)) {
            string = PhotonGlobalState.getInstance().getDefaultApplicationID();
        }
        if (StringHelper.hasText(string)) {
            PhotonSessionStatePerApp photonSessionStatePerApp;
            PhotonRequestState photonRequestState = null;
            if (photonSessionState != null && (photonSessionStatePerApp = photonSessionState.state(string)).isNotEmpty()) {
                photonRequestState = new PhotonRequestState(photonSessionStatePerApp);
            }
            if (photonRequestState == null) {
                photonRequestState = new PhotonRequestState(PhotonGlobalState.state(string));
            }
            RequestSettings.setRequestState(iRequestWebScopeWithoutResponse, string, photonRequestState);
        } else {
            LOGGER.warn("No application ID is present - please check if you really need this filter");
        }
    }

    @Override
    public void beforeRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        XServletFilterAppIDFromSessionID.setStatePerApp(iRequestWebScope);
    }

    @Override
    public void afterRequest(@Nonnull IRequestWebScope iRequestWebScope) {
    }
}

