/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.audit;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.audit.AuditHelper;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.TrackedRequest;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AuditingParallelRunningRequestCallback
implements IParallelRunningRequestCallback {
    public static final AuditingParallelRunningRequestCallback INSTANCE = new AuditingParallelRunningRequestCallback();

    @Override
    public void onParallelRunningRequests(@Nonnegative int n, @Nonnull @Nonempty List<TrackedRequest> list) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (TrackedRequest trackedRequest : list) {
            commonsArrayList.add(trackedRequest.getRequestScope().getURLDecoded());
        }
        AuditHelper.onAuditExecuteSuccess("parallel-running-requests", n, commonsArrayList);
    }

    @Override
    public void onParallelRunningRequestsBelowLimit() {
        AuditHelper.onAuditExecuteSuccess("parallel-running-requests", "back-to-normal");
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

