/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.configfile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.id.IHasID;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IHasDescription;
import com.helger.photon.core.configfile.EConfigurationFileSyntax;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ConfigurationFile
implements IHasID<String>,
IHasDescription {
    private final IReadableResource m_aRes;
    private final String m_sID;
    private String m_sDescription;
    private Charset m_aDefaultCharset = StandardCharsets.UTF_8;
    private EConfigurationFileSyntax m_eSyntaxHighlightLanguage = EConfigurationFileSyntax.NONE;

    @Nonnull
    private static String _unify(@Nonnull String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    public ConfigurationFile(@Nonnull IReadableResource iReadableResource) {
        this.m_aRes = ValueEnforcer.notNull(iReadableResource, "Resource");
        this.m_sID = ConfigurationFile._unify(this.m_aRes.getPath());
    }

    @Override
    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IReadableResource getResource() {
        return this.m_aRes;
    }

    public boolean exists() {
        return this.m_aRes.exists();
    }

    @Nullable
    public String getContentAsString() {
        return this.getContentAsString(this.m_aDefaultCharset);
    }

    @Nullable
    public String getContentAsString(@Nonnull Charset charset) {
        return StreamHelper.getAllBytesAsString(this.m_aRes, charset);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    public ConfigurationFile setDescription(@Nullable String string) {
        this.m_sDescription = string;
        return this;
    }

    @Nonnull
    public Charset getDefaultCharset() {
        return this.m_aDefaultCharset;
    }

    @Nonnull
    public ConfigurationFile setDefaultCharset(@Nonnull Charset charset) {
        this.m_aDefaultCharset = ValueEnforcer.notNull(charset, "DefaultCharset");
        return this;
    }

    @Nonnull
    public EConfigurationFileSyntax getSyntaxHighlightLanguage() {
        return this.m_eSyntaxHighlightLanguage;
    }

    @Nonnull
    public ConfigurationFile setSyntaxHighlightLanguage(@Nonnull EConfigurationFileSyntax eConfigurationFileSyntax) {
        this.m_eSyntaxHighlightLanguage = ValueEnforcer.notNull(eConfigurationFileSyntax, "SyntaxHighlightLanguage");
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Resource", this.m_aRes).append("ID", this.m_sID).append("Description", this.m_sDescription).append("DefaultCharset", this.m_aDefaultCharset).append("Syntax", this.m_eSyntaxHighlightLanguage).getToString();
    }
}

