/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.configfile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.configfile.ConfigurationFile;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import javax.annotation.Nonnull;

public final class ConfigurationFileManager
extends AbstractGlobalSingleton {
    private final ICommonsOrderedMap<String, ConfigurationFile> m_aMap = new CommonsLinkedHashMap<String, ConfigurationFile>();

    @Deprecated
    @UsedViaReflection
    public ConfigurationFileManager() {
    }

    @Nonnull
    public static ConfigurationFileManager getInstance() {
        return ConfigurationFileManager.getGlobalSingleton(ConfigurationFileManager.class);
    }

    public void registerConfigurationFile(@Nonnull ConfigurationFile configurationFile) {
        ValueEnforcer.notNull(configurationFile, "ConfigurationFile");
        String string = configurationFile.getID();
        if (this.m_aMap.containsKey(string)) {
            throw new IllegalArgumentException("A configuration file " + string + " is already registered!");
        }
        this.m_aMap.put(string, configurationFile);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ConfigurationFile> getAllConfigurationFiles() {
        return this.m_aMap.copyOfValues();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Map", this.m_aMap).getToString();
    }
}

