/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.csrf;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.string.StringHelper;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CSRFManager
extends AbstractGlobalWebSingleton {
    public static final int NONCE_BYTES = 64;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSRFManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aNonces = new CommonsHashSet<String>();

    @Deprecated
    @UsedViaReflection
    public CSRFManager() {
    }

    @Nonnull
    public static CSRFManager getInstance() {
        return CSRFManager.getGlobalSingleton(CSRFManager.class);
    }

    @Nullable
    public static CSRFManager getInstanceIfInstantiated() {
        return CSRFManager.getGlobalSingletonIfInstantiated(CSRFManager.class);
    }

    @Nonnull
    @Nonempty
    public String createNewNonce() {
        return this.m_aRWLock.writeLockedGet(() -> {
            String string;
            int n = 0;
            Random random = new Random();
            do {
                byte[] byArray = new byte[64];
                random.nextBytes(byArray);
                string = StringHelper.getHexEncoded(byArray);
                if (++n <= 100) continue;
                throw new IllegalStateException("Failed to create a unique nonce after " + n + " tries!");
            } while (!this.m_aNonces.add(string));
            return string;
        });
    }

    public void removeNonce(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Nonce");
        this.m_aRWLock.writeLocked(() -> {
            if (!this.m_aNonces.remove(string)) {
                LOGGER.error("Failed to remove nonce '" + string + "'");
            }
        });
    }

    public boolean isValidNonce(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aNonces.contains(string));
    }

    @Nonnegative
    public int getNonceCount() {
        return this.m_aRWLock.readLockedInt(this.m_aNonces::size);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllNonces() {
        return this.m_aRWLock.readLockedGet(this.m_aNonces::getClone);
    }
}

