/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.csrf;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.csrf.CSRFManager;
import com.helger.scope.IScope;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CSRFSessionManager
extends AbstractSessionWebSingleton {
    @GuardedBy(value="m_aRWLock")
    private String m_sNonce = CSRFManager.getInstance().createNewNonce();

    @Deprecated
    @UsedViaReflection
    public CSRFSessionManager() {
    }

    @Nonnull
    public static CSRFSessionManager getInstance() {
        return CSRFSessionManager.getSessionSingleton(CSRFSessionManager.class);
    }

    @Override
    protected void onDestroy(@Nonnull IScope iScope) {
        this.m_aRWLock.writeLocked(() -> {
            CSRFManager cSRFManager = CSRFManager.getInstanceIfInstantiated();
            if (cSRFManager != null) {
                cSRFManager.removeNonce(this.m_sNonce);
            }
            this.m_sNonce = null;
        });
    }

    @Nonnull
    @Nonempty
    public String getNonce() {
        return this.m_aRWLock.readLockedGet(() -> this.m_sNonce);
    }

    public boolean isExpectedNonce(@Nullable String string) {
        String string2 = this.getNonce();
        return StringHelper.hasText(string2) && string2.equals(string) && CSRFManager.getInstance().isValidNonce(string);
    }

    public void generateNewNonce() {
        CSRFManager cSRFManager = CSRFManager.getInstance();
        this.m_aRWLock.writeLocked(() -> {
            cSRFManager.removeNonce(this.m_sNonce);
            this.m_sNonce = cSRFManager.createNewNonce();
        });
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("nonce", this.m_sNonce).getToString();
    }
}

