/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.execcontext;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.execcontext.SimpleWebExecutionContext;
import com.helger.photon.core.menu.IMenuItemPage;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.user.IUser;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LayoutExecutionContext
extends SimpleWebExecutionContext
implements ILayoutExecutionContext {
    private final IMenuItemPage m_aSelectedMenuItem;
    private transient SimpleURL m_aSelfHref;

    public LayoutExecutionContext(@Nonnull ILayoutExecutionContext iLayoutExecutionContext) {
        this(iLayoutExecutionContext, iLayoutExecutionContext.getSelectedMenuItem());
    }

    public LayoutExecutionContext(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nonnull IMenuItemPage iMenuItemPage) {
        super(iSimpleWebExecutionContext);
        this.m_aSelectedMenuItem = ValueEnforcer.notNull(iMenuItemPage, "SelectedMenuItem");
    }

    @Override
    @Nonnull
    public final IMenuItemPage getSelectedMenuItem() {
        return this.m_aSelectedMenuItem;
    }

    @Override
    @Nonnull
    public final SimpleURL getSelfHref() {
        SimpleURL simpleURL = this.m_aSelfHref;
        if (simpleURL == null) {
            this.m_aSelfHref = simpleURL = this.getLinkToMenuItem(this.getSelectedMenuItemID());
        }
        return simpleURL.getClone();
    }

    @Override
    public final void postRedirectGet(@Nonnull ISimpleURL iSimpleURL, @Nullable IHCNode iHCNode) throws ForcedRedirectException {
        throw new ForcedRedirectException((String)this.m_aSelectedMenuItem.getID(), iSimpleURL, iHCNode);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("selectedMenuItem", this.m_aSelectedMenuItem).getToString();
    }

    @Nonnull
    public static LayoutExecutionContext createForAjaxOrAction(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        Locale locale = RequestSettings.getDisplayLocale(iRequestWebScopeWithoutResponse);
        IMenuTree iMenuTree = RequestSettings.getMenuTree(iRequestWebScopeWithoutResponse);
        IUser iUser = LoggedInUserManager.getInstance().getCurrentUser();
        IMenuItemPage iMenuItemPage = RequestSettings.getMenuItem(iRequestWebScopeWithoutResponse);
        return new LayoutExecutionContext(new SimpleWebExecutionContext(iRequestWebScopeWithoutResponse, locale, iMenuTree, iUser), iMenuItemPage);
    }
}

