/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.execcontext;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.security.user.IUser;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleWebExecutionContext
implements ISimpleWebExecutionContext {
    private final IRequestWebScopeWithoutResponse m_aRequestScope;
    private final Locale m_aDisplayLocale;
    private final IMenuTree m_aMenuTree;
    private final IUser m_aLoggedInUser;
    private final boolean m_bIsLoggedInUserAdministrator;

    public SimpleWebExecutionContext(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext) {
        this(iSimpleWebExecutionContext.getRequestScope(), iSimpleWebExecutionContext.getDisplayLocale(), iSimpleWebExecutionContext.getMenuTree(), iSimpleWebExecutionContext.getLoggedInUser());
    }

    public SimpleWebExecutionContext(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Locale locale, @Nonnull IMenuTree iMenuTree, @Nullable IUser iUser) {
        this.m_aRequestScope = ValueEnforcer.notNull(iRequestWebScopeWithoutResponse, "RequestScope");
        this.m_aDisplayLocale = ValueEnforcer.notNull(locale, "DisplayLocale");
        this.m_aMenuTree = ValueEnforcer.notNull(iMenuTree, "MenuTree");
        this.m_aLoggedInUser = iUser;
        this.m_bIsLoggedInUserAdministrator = iUser != null && iUser.isAdministrator();
    }

    @Override
    @Nonnull
    public final IRequestWebScopeWithoutResponse getRequestScope() {
        return this.m_aRequestScope;
    }

    @Override
    @Nonnull
    public final Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Override
    @Nonnull
    public final IMenuTree getMenuTree() {
        return this.m_aMenuTree;
    }

    @Override
    @Nullable
    public final IUser getLoggedInUser() {
        return this.m_aLoggedInUser;
    }

    @Override
    public final boolean isLoggedInUserAdministrator() {
        return this.m_bIsLoggedInUserAdministrator;
    }

    public String toString() {
        return new ToStringGenerator(this).append("RequestURL", this.m_aRequestScope.getURLEncoded()).append("DisplayLocale", this.m_aDisplayLocale).append("MenuTree#", this.m_aMenuTree.getItemCount()).append("LoggedInUserID", this.getLoggedInUserID()).append("LoggedInUserAdministrator", this.m_bIsLoggedInUserAdministrator).getToString();
    }
}

