/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.favorites;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.core.favorites.IFavorite;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Favorite
implements IFavorite {
    public static final ObjectType OT = new ObjectType("favourite");
    private final String m_sID;
    private final String m_sUserID;
    private final String m_sApplicationID;
    private String m_sMenuItemID;
    private String m_sDisplayName;
    private ICommonsMap<String, String> m_aAdditionalParams;

    public Favorite(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nullable Map<String, String> map) {
        this(GlobalIDFactory.getNewPersistentStringID(), string, string2, string3, string4, map);
    }

    Favorite(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5, @Nullable Map<String, String> map) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_sUserID = ValueEnforcer.notEmpty(string2, "User ID");
        this.m_sApplicationID = ValueEnforcer.notEmpty(string3, "application ID");
        this.setMenuItemID(string4);
        this.setDisplayName(string5);
        this.setAdditionalParams(map);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getUserID() {
        return this.m_sUserID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getApplicationID() {
        return this.m_sApplicationID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getMenuItemID() {
        return this.m_sMenuItemID;
    }

    @Nonnull
    public final EChange setMenuItemID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "menu item ID");
        if (string.equals(this.m_sMenuItemID)) {
            return EChange.UNCHANGED;
        }
        this.m_sMenuItemID = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public final EChange setDisplayName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "display name");
        if (string.equals(this.m_sDisplayName)) {
            return EChange.UNCHANGED;
        }
        this.m_sDisplayName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllAdditionalParams() {
        return (ICommonsMap)this.m_aAdditionalParams.getClone();
    }

    @Nonnull
    public final EChange setAdditionalParams(@Nullable Map<String, String> map) {
        CommonsHashMap<String, String> commonsHashMap = new CommonsHashMap<String, String>(map);
        if (((Object)commonsHashMap).equals(this.m_aAdditionalParams)) {
            return EChange.UNCHANGED;
        }
        this.m_aAdditionalParams = commonsHashMap;
        return EChange.CHANGED;
    }

    @Override
    public boolean hasSameContent(@Nullable String string, @Nullable String string2, @Nullable Map<String, String> map) {
        CommonsHashMap<String, String> commonsHashMap = new CommonsHashMap<String, String>(map);
        return this.m_sApplicationID.equals(string) && this.m_sMenuItemID.equals(string2) && this.m_aAdditionalParams.equals(commonsHashMap);
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator(this).append("id", this.m_sID).append("userID", this.m_sUserID).append("applicationID", this.m_sApplicationID).append("menuItemID", this.m_sMenuItemID).append("displayName", this.m_sDisplayName).append("additionalParams", this.m_aAdditionalParams).getToString();
    }
}

