/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.favorites;

import com.helger.collection.multimap.IMultiMapListBased;
import com.helger.collection.multimap.MultiHashMapArrayListBased;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.dao.DAOException;
import com.helger.dao.EDAOActionType;
import com.helger.photon.app.dao.AbstractPhotonWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.core.favorites.Favorite;
import com.helger.photon.core.favorites.IFavorite;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FavoriteManager
extends AbstractPhotonWALDAO<Favorite> {
    private static final String ELEMENT_ITEM = "favorite";
    private final MultiHashMapArrayListBased<String, Favorite> m_aMap = new MultiHashMapArrayListBased();

    public FavoriteManager(@Nonnull @Nonempty String string) throws DAOException {
        super(Favorite.class, string);
        this.initialRead();
    }

    @Override
    protected void onRecoveryCreate(@Nonnull Favorite favorite) {
        this._addItem(favorite);
    }

    @Override
    protected void onRecoveryUpdate(@Nonnull Favorite favorite) {
        this._addItem(favorite);
    }

    @Override
    protected void onRecoveryDelete(@Nonnull Favorite favorite) {
        this.m_aMap.removeSingle(favorite.getUserID(), favorite);
    }

    @Override
    @Nonnull
    protected EChange onRead(@Nonnull IMicroDocument iMicroDocument) {
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements(ELEMENT_ITEM)) {
            this._addItem(MicroTypeConverter.convertToNative(iMicroElement, Favorite.class));
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    protected IMicroDocument createWriteData() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("root");
        for (ICommonsList iCommonsList : this.m_aMap.getSortedByKey(Comparator.naturalOrder()).values()) {
            for (Favorite favorite : iCommonsList) {
                iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(favorite, ELEMENT_ITEM));
            }
        }
        return microDocument;
    }

    @Override
    public boolean isReloadable() {
        return true;
    }

    @Override
    public void reload() throws DAOException {
        this.m_aRWLock.writeLockedThrowing(() -> {
            this.m_aMap.clear();
            this.initialRead();
        });
    }

    @MustBeLocked(value=ELockType.WRITE)
    private void _addItem(@Nonnull Favorite favorite) {
        ValueEnforcer.notNull(favorite, "Favorite");
        this.m_aMap.putSingle(favorite.getUserID(), favorite);
    }

    @Nonnegative
    public long getSize() {
        return this.m_aRWLock.readLockedLong(this.m_aMap::getTotalValueCount);
    }

    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aMap::isEmpty);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllUserIDsWithFavorites() {
        return this.m_aRWLock.readLockedGet(this.m_aMap::copyOfKeySet);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IFavorite> getAllFavoritesOfUser(@Nullable String string) {
        return this.m_aRWLock.readLockedGet(() -> new CommonsArrayList<Collection>((Collection)this.m_aMap.get(string)));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IMultiMapListBased<String, IFavorite> getAll() {
        MultiHashMapArrayListBased<String, IFavorite> multiHashMapArrayListBased = new MultiHashMapArrayListBased<String, IFavorite>();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            multiHashMapArrayListBased.put(entry.getKey(), new CommonsArrayList<Collection>((Collection)entry.getValue()));
        }
        return multiHashMapArrayListBased;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IFavorite> getAllFavorites() {
        CommonsArrayList<IFavorite> commonsArrayList = new CommonsArrayList<IFavorite>();
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            commonsArrayList.addAll((Collection)entry.getValue());
        }
        return commonsArrayList;
    }

    public boolean containsFavoritesOfUser(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        ICommonsList iCommonsList = this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get(string));
        return iCommonsList != null && iCommonsList.isNotEmpty();
    }

    public boolean isFavorite(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        return this.getFavorite(string, string2, string3, map) != null;
    }

    @Nullable
    public IFavorite getFavorite(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        ICommonsList iCommonsList;
        if (StringHelper.hasText(string) && StringHelper.hasText(string2) && StringHelper.hasText(string3) && (iCommonsList = this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get(string))) != null) {
            return iCommonsList.findFirst(favorite -> favorite.hasSameContent(string2, string3, map));
        }
        return null;
    }

    @Nullable
    public IFavorite getFavorite(@Nullable String string, @Nullable String string2) {
        ICommonsList iCommonsList;
        if (StringHelper.hasText(string) && StringHelper.hasText(string2) && (iCommonsList = this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get(string))) != null) {
            return iCommonsList.findFirst(favorite -> favorite.getID().equals(string2));
        }
        return null;
    }

    @Nonnull
    public IFavorite addFavorite(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nullable Map<String, String> map) {
        Favorite favorite = new Favorite(string, string2, string3, string4, map);
        this.m_aRWLock.writeLocked(() -> {
            this._addItem(favorite);
            this.markAsChanged(favorite, EDAOActionType.CREATE);
        });
        AuditHelper.onAuditCreateSuccess(Favorite.OT, favorite.getID(), string, string2, string3, string4, map);
        return favorite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange updateFavorite(@Nullable String string, @Nullable String string2, @Nonnull @Nonempty String string3, @Nonnull @Nonempty String string4, @Nullable Map<String, String> map) {
        Favorite favorite2;
        ICommonsList iCommonsList = this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get(string));
        Favorite favorite3 = favorite2 = iCommonsList == null ? null : iCommonsList.findFirst(favorite -> favorite.getID().equals(string2));
        if (favorite2 == null) {
            AuditHelper.onAuditModifyFailure(Favorite.OT, string2, "no-such-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or(favorite2.setMenuItemID(string3));
            eChange = eChange.or(favorite2.setDisplayName(string4));
            eChange = eChange.or(favorite2.setAdditionalParams(map));
            if (eChange.isUnchanged()) {
                AuditHelper.onAuditModifyFailure(Favorite.OT, favorite2.getID(), "unchanged");
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            this.markAsChanged(favorite2, EDAOActionType.UPDATE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(Favorite.OT, favorite2.getID(), string, string3, string4, map);
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange removeFavorite(@Nullable String string, @Nullable String string2) {
        Favorite favorite2;
        ICommonsList iCommonsList = this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMap.get(string));
        Favorite favorite3 = favorite2 = iCommonsList == null ? null : iCommonsList.findFirst(favorite -> favorite.getID().equals(string2));
        if (favorite2 == null) {
            AuditHelper.onAuditDeleteFailure(Favorite.OT, string, string2, "no-such-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (iCommonsList.removeObject(favorite2).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(Favorite.OT, string2, "no-such-id");
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.markAsChanged(favorite2, EDAOActionType.DELETE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(Favorite.OT, string2);
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EChange removeAllFavoritesOfUser(@Nullable String string) {
        this.m_aRWLock.writeLock().lock();
        try {
            ICommonsList iCommonsList = (ICommonsList)this.m_aMap.remove(string);
            if (iCommonsList == null) {
                AuditHelper.onAuditDeleteFailure(Favorite.OT, string, "no-such-user-id");
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.markAsChanged(iCommonsList, EDAOActionType.DELETE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(Favorite.OT, string);
        return EChange.CHANGED;
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }
}

