/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.favorites;

import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.photon.core.favorites.Favorite;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FavoriteMicroTypeConverter
implements IMicroTypeConverter<Favorite> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_USER_ID = "userid";
    private static final String ATTR_APPLICATION_ID = "applicationid";
    private static final String ATTR_MENU_ITEM_ID = "menuitemid";
    private static final String ATTR_DISPLAY_NAME = "displayname";
    private static final String ELEMENT_ADDITIONAL_PARAM = "additionalparam";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Favorite favorite, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, favorite.getID());
        microElement.setAttribute(ATTR_USER_ID, favorite.getUserID());
        microElement.setAttribute(ATTR_APPLICATION_ID, favorite.getApplicationID());
        microElement.setAttribute(ATTR_MENU_ITEM_ID, favorite.getMenuItemID());
        microElement.setAttribute(ATTR_DISPLAY_NAME, favorite.getDisplayName());
        for (Map.Entry entry : favorite.getAllAdditionalParams().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
            IMicroElement iMicroElement = microElement.appendElement(ELEMENT_ADDITIONAL_PARAM);
            iMicroElement.setAttribute(ATTR_NAME, (String)entry.getKey());
            iMicroElement.setAttribute(ATTR_VALUE, (String)entry.getValue());
        }
        return microElement;
    }

    @Override
    @Nonnull
    public Favorite convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        String string2 = iMicroElement.getAttributeValue(ATTR_USER_ID);
        String string3 = iMicroElement.getAttributeValue(ATTR_APPLICATION_ID);
        String string4 = iMicroElement.getAttributeValue(ATTR_MENU_ITEM_ID);
        String string5 = iMicroElement.getAttributeValue(ATTR_DISPLAY_NAME);
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_ADDITIONAL_PARAM)) {
            commonsLinkedHashMap.put(iMicroElement2.getAttributeValue(ATTR_NAME), iMicroElement2.getAttributeValue(ATTR_VALUE));
        }
        return new Favorite(string, string2, string3, string4, string5, commonsLinkedHashMap);
    }
}

