/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.form;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.photon.core.form.RequestField;
import com.helger.web.scope.IRequestParamContainer;
import javax.annotation.Nonnull;

public class RequestFieldBoolean
extends RequestField
implements IHCRequestFieldBoolean {
    public static final String VALUE_CHECKED = Boolean.TRUE.toString();
    public static final String VALUE_UNCHECKED = Boolean.FALSE.toString();
    private final boolean m_bDefaultValue;

    public RequestFieldBoolean(@Nonnull @Nonempty String string, boolean bl) {
        super(string, RequestFieldBoolean.getStringValue(bl));
        this.m_bDefaultValue = bl;
    }

    @Nonnull
    @Nonempty
    public static String getStringValue(boolean bl) {
        return bl ? VALUE_CHECKED : VALUE_UNCHECKED;
    }

    public boolean isChecked(@Nonnull IRequestParamContainer iRequestParamContainer) {
        return iRequestParamContainer.isCheckBoxChecked(this.getFieldName(), this.m_bDefaultValue);
    }

    @Override
    public boolean isChecked() {
        return this.isChecked(RequestFieldBoolean.getParams());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RequestFieldBoolean requestFieldBoolean = (RequestFieldBoolean)object;
        return this.m_bDefaultValue == requestFieldBoolean.m_bDefaultValue;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_bDefaultValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("DefaultValue", this.m_bDefaultValue).getToString();
    }
}

