/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.form;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.photon.core.form.RequestField;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.XMLGregorianCalendar;

public class RequestFieldDate
extends RequestField {
    private final Locale m_aDisplayLocale;

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Locale locale) {
        super(string, string2);
        this.m_aDisplayLocale = ValueEnforcer.notNull(locale, "DisplayLocale");
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        this(string, (String)null, locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable LocalDate localDate, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString(localDate, locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable LocalTime localTime, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString(localTime, locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable LocalDateTime localDateTime, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString(localDateTime, locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable ZonedDateTime zonedDateTime, @Nonnull Locale locale) {
        this(string, PDTToString.getAsString(zonedDateTime, locale), locale);
    }

    public RequestFieldDate(@Nonnull @Nonempty String string, @Nullable XMLGregorianCalendar xMLGregorianCalendar, @Nonnull Locale locale) {
        this(string, PDTXMLConverter.getZonedDateTime(xMLGregorianCalendar), locale);
    }

    @Nonnull
    public final Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RequestFieldDate requestFieldDate = (RequestFieldDate)object;
        return this.m_aDisplayLocale.equals(requestFieldDate.m_aDisplayLocale);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aDisplayLocale).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("DisplayLocale", this.m_aDisplayLocale).getToString();
    }

    @Nonnull
    public static RequestFieldDate createLocalDateNow(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        return new RequestFieldDate(string, PDTFactory.getCurrentLocalDate(), locale);
    }

    @Nonnull
    public static RequestFieldDate createLocalDateTimeNow(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        return new RequestFieldDate(string, PDTFactory.getCurrentLocalDateTime(), locale);
    }

    @Nonnull
    public static RequestFieldDate createDateTimeNow(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        return new RequestFieldDate(string, PDTFactory.getCurrentZonedDateTime(), locale);
    }
}

