/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.form;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.request.IHCRequestFieldBooleanMultiValue;
import com.helger.photon.core.form.SessionBackedRequestField;
import javax.annotation.Nonnull;

public class SessionBackedRequestFieldBooleanMultiValue
extends SessionBackedRequestField
implements IHCRequestFieldBooleanMultiValue {
    private final String m_sValue;
    private final boolean m_bDefaultValue;

    public SessionBackedRequestFieldBooleanMultiValue(@Nonnull @Nonempty String string, @Nonnull String string2, boolean bl) {
        super(string, bl ? string2 : null);
        this.m_sValue = ValueEnforcer.notNull(string2, "Value");
        this.m_bDefaultValue = bl;
    }

    @Override
    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    @Override
    public boolean isChecked() {
        return SessionBackedRequestFieldBooleanMultiValue.getParams().hasCheckBoxValue(this.getFieldName(), this.m_sValue, this.m_bDefaultValue);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SessionBackedRequestFieldBooleanMultiValue sessionBackedRequestFieldBooleanMultiValue = (SessionBackedRequestFieldBooleanMultiValue)object;
        return this.m_sValue.equals(sessionBackedRequestFieldBooleanMultiValue.m_sValue) && this.m_bDefaultValue == sessionBackedRequestFieldBooleanMultiValue.m_bDefaultValue;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sValue).append(this.m_bDefaultValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Value", this.m_sValue).append("DefaultValue", this.m_bDefaultValue).getToString();
    }
}

