/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.go;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.photon.app.url.LinkHelper;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GoMappingItem
implements Serializable {
    private final String m_sKey;
    private final boolean m_bIsInternal;
    private final ISimpleURL m_aTargetURL;
    private final boolean m_bIsEditable;

    public GoMappingItem(@Nonnull @Nonempty String string, boolean bl, @Nonnull @Nonempty String string2, boolean bl2) {
        this(string, bl, bl ? LinkHelper.getURLWithContext(string2) : new SimpleURL(string2), bl2);
    }

    public GoMappingItem(@Nonnull @Nonempty String string, boolean bl, @Nonnull ISimpleURL iSimpleURL, boolean bl2) {
        this.m_sKey = ValueEnforcer.notEmpty(string, "Key");
        this.m_bIsInternal = bl;
        this.m_aTargetURL = ValueEnforcer.notNull(iSimpleURL, "TargetURL");
        this.m_bIsEditable = bl2;
    }

    @Nonnull
    @Nonempty
    public String getKey() {
        return this.m_sKey;
    }

    public boolean isInternal() {
        return this.m_bIsInternal;
    }

    @Nonnull
    public ISimpleURL getTargetURLReadonly() {
        return this.m_aTargetURL;
    }

    @Nonnull
    @ReturnsMutableCopy
    public SimpleURL getTargetURL() {
        return new SimpleURL(this.m_aTargetURL);
    }

    @Nonnull
    public String getTargetURLAsString() {
        return this.m_aTargetURL.getAsStringWithEncodedParameters();
    }

    public boolean isEditable() {
        return this.m_bIsEditable;
    }

    @Nonnull
    public GoMappingItem getAsNotEditable() {
        if (!this.m_bIsEditable) {
            return this;
        }
        return new GoMappingItem(this.m_sKey, this.m_bIsInternal, this.m_aTargetURL, false);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        GoMappingItem goMappingItem = (GoMappingItem)object;
        return this.m_sKey.equals(goMappingItem.m_sKey) && this.m_bIsInternal == goMappingItem.m_bIsInternal && this.m_aTargetURL.equals(goMappingItem.m_aTargetURL) && this.m_bIsEditable == goMappingItem.m_bIsEditable;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sKey).append(this.m_bIsInternal).append(this.m_aTargetURL).append(this.m_bIsEditable).getHashCode();
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator(this).append("key", this.m_sKey).append("isInternal", this.m_bIsInternal).append("target", this.m_aTargetURL).append("isEditable", this.m_bIsEditable).getToString();
    }
}

