/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.go;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.functional.IFunction;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.url.SimpleURL;
import com.helger.photon.core.go.GoMappingItem;
import com.helger.photon.core.menu.IMenuItemExternal;
import com.helger.photon.core.menu.IMenuObject;
import com.helger.photon.core.menu.IMenuTree;
import com.helger.photon.core.mgr.PhotonCoreManager;
import com.helger.photon.core.requestparam.RequestParameterManager;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoXServletHandler.class);
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsError = StatisticsManager.getKeyedCounterHandler(GoXServletHandler.class.getName() + "$error");
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsOK = StatisticsManager.getKeyedCounterHandler(GoXServletHandler.class.getName() + "$ok");
    private final IFunction<? super IRequestWebScopeWithoutResponse, ? extends IMenuTree> m_aMenuTreeSupplier;

    public GoXServletHandler(@Nonnull IFunction<? super IRequestWebScopeWithoutResponse, ? extends IMenuTree> iFunction) {
        ValueEnforcer.notNull(iFunction, "MenuTreeSupplier");
        this.m_aMenuTreeSupplier = iFunction;
    }

    @Nullable
    @OverrideOnDemand
    protected GoMappingItem getResolvedGoMappingItem(@Nonnull String string) {
        return PhotonCoreManager.getGoMappingMgr().getItemOfKey(string);
    }

    @Nonnull
    @OverrideOnDemand
    protected SimpleURL getURLForNonExistingItem(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string) {
        return new SimpleURL(iRequestWebScopeWithoutResponse.getFullContextPath());
    }

    @OverrideOnDemand
    protected void modifyResultURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull String string, @Nonnull SimpleURL simpleURL) {
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        Object object;
        String string = iRequestWebScopeWithoutResponse.getPathWithinServlet();
        if (string.length() > 0) {
            string = string.substring(1);
        }
        SimpleURL simpleURL = null;
        GoMappingItem goMappingItem = this.getResolvedGoMappingItem(string);
        if (goMappingItem == null) {
            LOGGER.warn("No such go-mapping item '" + string + "'");
            simpleURL = this.getURLForNonExistingItem(iRequestWebScopeWithoutResponse, string);
            s_aStatsError.increment(string);
        } else {
            String object2;
            Object object3;
            if (goMappingItem.isInternal() && (object3 = (IMenuTree)this.m_aMenuTreeSupplier.apply(iRequestWebScopeWithoutResponse)) != null && (object = (IMenuObject)object3.getItemDataWithID(object2 = RequestParameterManager.getInstance().getMenuItemFromURL(goMappingItem.getTargetURL(), (IMenuTree)object3))) instanceof IMenuItemExternal) {
                simpleURL = new SimpleURL(((IMenuItemExternal)object).getURL());
            }
            if (simpleURL == null) {
                simpleURL = goMappingItem.getTargetURL();
            }
            this.modifyResultURL(iRequestWebScopeWithoutResponse, string, simpleURL);
            s_aStatsOK.increment(string);
        }
        for (Map.Entry entry : iRequestWebScopeWithoutResponse.params().entrySet()) {
            object = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String) {
                simpleURL.add((String)object, (String)v);
                continue;
            }
            if (!(v instanceof String[])) continue;
            for (String string2 : (String[])v) {
                simpleURL.add((String)object, string2);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Following go-mapping item '" + string + "' to " + simpleURL.getAsStringWithEncodedParameters());
        } else if (GlobalDebug.isDebugMode()) {
            LOGGER.info("Following go-mapping item '" + string + "' to " + simpleURL.getAsStringWithEncodedParameters());
        }
        unifiedResponse.setRedirect(simpleURL);
    }
}

