/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.html;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.html.metadata.HCHead;
import com.helger.html.hc.html.metadata.HCMeta;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.meta.EStandardMetaElement;
import com.helger.html.meta.IMetaElement;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.PhotonAppManager;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.app.html.PhotonJS;
import com.helger.photon.app.html.PhotonMetaElements;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class AbstractHTMLProvider
implements IHTMLProvider {
    @Nonnull
    @OverrideOnDemand
    protected HCHtml createHCHtml(@Nonnull Locale locale) {
        return (HCHtml)new HCHtml().setLanguage(locale.getLanguage());
    }

    @OverrideOnDemand
    protected void addMetaElements(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull HCHead hCHead) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        IMimeType iMimeType = PhotonHTMLHelper.getMimeType(iRequestWebScopeWithoutResponse);
        commonsArrayList.add(EStandardMetaElement.CONTENT_TYPE.getAsMetaElement(iMimeType.getAsString()));
        PhotonMetaElements.getAllRegisteredMetaElementsForGlobal(commonsArrayList);
        PhotonMetaElements.getAllRegisteredMetaElementsForThisRequest(commonsArrayList);
        for (IMetaElement iMetaElement : commonsArrayList) {
            for (Map.Entry<Locale, String> entry : iMetaElement.getContent()) {
                HCMeta hCMeta = new HCMeta();
                if (iMetaElement.isHttpEquiv()) {
                    hCMeta.setHttpEquiv(iMetaElement.getName());
                } else {
                    hCMeta.setName(iMetaElement.getName());
                }
                hCMeta.setContent(entry.getValue());
                Locale locale = entry.getKey();
                if (locale != null && !LocaleHelper.isSpecialLocale(locale)) {
                    hCMeta.setLanguage(locale.toString());
                }
                hCHead.metaElements().add(hCMeta);
            }
        }
    }

    @OverrideOnDemand
    protected void addGlobalAndPerRequestCSSAndJS(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull HCHtml hCHtml) {
        boolean bl = HCSettings.isUseRegularResources();
        HCHead hCHead = hCHtml.head();
        ICommonsOrderedSet<ICSSPathProvider> iCommonsOrderedSet = PhotonCSS.getAllRegisteredCSSIncludesForGlobal();
        PhotonCSS.getAllRegisteredCSSIncludesForThisRequest(iCommonsOrderedSet);
        for (ICSSPathProvider object2 : iCommonsOrderedSet) {
            hCHead.addCSS(PhotonHTMLHelper.getCSSNode(iRequestWebScopeWithoutResponse, object2, bl));
        }
        ICommonsOrderedSet<IJSPathProvider> iCommonsOrderedSet2 = PhotonJS.getAllRegisteredJSIncludesForGlobal();
        PhotonJS.getAllRegisteredJSIncludesForThisRequest((Collection<? super IJSPathProvider>)iCommonsOrderedSet2);
        Iterator iterator = iCommonsOrderedSet2.iterator();
        while (iterator.hasNext()) {
            IJSPathProvider iJSPathProvider = (IJSPathProvider)iterator.next();
            hCHead.addJS(PhotonHTMLHelper.getJSNode(iRequestWebScopeWithoutResponse, iJSPathProvider, bl));
        }
    }

    protected abstract void fillHeadAndBody(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull HCHtml var2, @Nonnull Locale var3);

    @Override
    @Nonnull
    public final HCHtml createHTML(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) throws ForcedRedirectException {
        Locale locale = RequestSettings.getDisplayLocale(iRequestWebScopeWithoutResponse);
        IHCConversionSettings iHCConversionSettings = HCSettings.getConversionSettings();
        HCHtml hCHtml = this.createHCHtml(locale);
        this.fillHeadAndBody(iRequestWebScopeWithoutResponse, hCHtml, locale);
        HCRenderer.prepareForConversion(hCHtml, hCHtml.body(), iHCConversionSettings);
        this.addGlobalAndPerRequestCSSAndJS(iRequestWebScopeWithoutResponse, hCHtml);
        if (iHCConversionSettings.isExtractOutOfBandNodes()) {
            ICommonsList<IHCNode> iCommonsList = hCHtml.getAllOutOfBandNodesWithMergedInlineNodes();
            hCHtml.addAllOutOfBandNodesToHead(iCommonsList);
        }
        PhotonHTMLHelper.mergeExternalCSSAndJSNodes(iRequestWebScopeWithoutResponse, hCHtml.head(), PhotonAppSettings.isMergeCSSResources(), PhotonAppSettings.isMergeJSResources(), PhotonAppManager.getWebSiteResourceBundleMgr());
        if (HCSettings.isScriptsInBody()) {
            hCHtml.moveScriptElementsToBody();
        }
        return hCHtml;
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

