/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.lang.ICloneable;
import com.helger.smtp.settings.ISMTPSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class InternalErrorEmailSettings
implements ICloneable<InternalErrorEmailSettings> {
    private ISMTPSettings m_aSMTPSettings;
    private IEmailAddress m_aSenderAddress;
    private final ICommonsList<IEmailAddress> m_aReceiverAddresses = new CommonsArrayList<IEmailAddress>();

    public InternalErrorEmailSettings() {
    }

    public InternalErrorEmailSettings(@Nonnull InternalErrorEmailSettings internalErrorEmailSettings) {
        ValueEnforcer.notNull(internalErrorEmailSettings, "Other");
        this.m_aSMTPSettings = internalErrorEmailSettings.m_aSMTPSettings;
        this.m_aSenderAddress = internalErrorEmailSettings.m_aSenderAddress;
        this.m_aReceiverAddresses.setAll((Iterable<IEmailAddress>)internalErrorEmailSettings.m_aReceiverAddresses);
    }

    @Nonnull
    public InternalErrorEmailSettings setSMTPSettings(@Nullable ISMTPSettings iSMTPSettings) {
        this.m_aSMTPSettings = iSMTPSettings;
        return this;
    }

    @Nullable
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSMTPSettings;
    }

    @Nonnull
    public InternalErrorEmailSettings setSenderAddress(@Nullable IEmailAddress iEmailAddress) {
        this.m_aSenderAddress = iEmailAddress;
        return this;
    }

    @Nullable
    public IEmailAddress getSenderAddress() {
        return this.m_aSenderAddress;
    }

    @Nonnull
    public InternalErrorEmailSettings setReceiverAddress(@Nullable IEmailAddress iEmailAddress) {
        return this.setReceiverAddresses((Iterable<? extends IEmailAddress>)(iEmailAddress == null ? null : new CommonsArrayList<IEmailAddress>(iEmailAddress)));
    }

    @Nonnull
    public InternalErrorEmailSettings setReceiverAddresses(@Nullable Iterable<? extends IEmailAddress> iterable) {
        if (iterable != null && CollectionHelper.containsAnyNullElement(iterable)) {
            throw new IllegalArgumentException("The list of receiver addresses may not contain any null element!");
        }
        this.m_aReceiverAddresses.setAll(iterable);
        return this;
    }

    @Nonnull
    public InternalErrorEmailSettings setReceiverAddresses(IEmailAddress ... iEmailAddressArray) {
        if (iEmailAddressArray != null && ArrayHelper.containsAnyNullElement(iEmailAddressArray)) {
            throw new IllegalArgumentException("The array of receiver addresses may not contain any null element!");
        }
        this.m_aReceiverAddresses.setAll((IEmailAddress[])iEmailAddressArray);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IEmailAddress> getAllReceiverAddresses() {
        return (ICommonsList)this.m_aReceiverAddresses.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public InternalErrorEmailSettings getClone() {
        return new InternalErrorEmailSettings(this);
    }
}

