/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassPathHelper;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.mutable.MutableInt;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.photon.core.appid.RequestSettings;
import com.helger.photon.core.interror.InternalErrorEmailSettings;
import com.helger.photon.core.interror.InternalErrorMetadata;
import com.helger.photon.core.interror.InternalErrorSettings;
import com.helger.photon.core.interror.uihandler.IUIInternalErrorHandler;
import com.helger.scope.mgr.ScopeSessionManager;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.request.RequestLogger;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailAPI;
import com.helger.useragent.uaprofile.UAProfile;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.util.thread.ThreadDescriptor;
import com.helger.xml.util.thread.ThreadDescriptorList;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class InternalErrorHandler {
    public static final boolean DEFAULT_ENABLE_FULL_THREAD_DUMPS = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalErrorHandler.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsMap<String, MutableInt> s_aIntErrCache = new CommonsHashMap<String, MutableInt>();

    private InternalErrorHandler() {
    }

    @Nonnull
    @Nonempty
    public static String createNewErrorID() {
        try {
            return Integer.toString(GlobalIDFactory.getNewPersistentIntID());
        }
        catch (IllegalStateException illegalStateException) {
            return "t" + GlobalIDFactory.getNewIntID() + "_" + System.currentTimeMillis();
        }
    }

    @Nonnull
    @Nonempty
    public static String createNewInternalErrorID() {
        return "internal-error-" + InternalErrorHandler.createNewErrorID();
    }

    @Nonnull
    @Nonempty
    private static String _getThrowableAsString(@Nonnull Throwable throwable) {
        return throwable.getMessage() + " -- " + throwable.getClass().getName();
    }

    @Nonnull
    private static String _createMailSubject(@Nonnull InternalErrorMetadata internalErrorMetadata) {
        StringBuilder stringBuilder = new StringBuilder();
        if (GlobalDebug.isDebugMode()) {
            stringBuilder.append("[DEBUG] ");
        }
        if (GlobalDebug.isProductionMode()) {
            stringBuilder.append("[PRODUCTION] ");
        }
        stringBuilder.append("Internal error");
        String string = internalErrorMetadata.getFieldValue("Error Message", null);
        if (StringHelper.hasText(string)) {
            stringBuilder.append(": ").append(string);
        }
        stringBuilder.append(" [").append(internalErrorMetadata.getErrorID()).append(']');
        String string2 = stringBuilder.toString();
        return string2;
    }

    private static void _sendInternalErrorMailToVendor(@Nonnull InternalErrorMetadata internalErrorMetadata, @Nonnull ThreadDescriptor threadDescriptor, @Nullable ThreadDescriptorList threadDescriptorList, @Nonnull InternalErrorEmailSettings internalErrorEmailSettings, @Nullable IEmailAttachmentList iEmailAttachmentList, boolean bl, @Nonnegative int n) {
        block14: {
            Serializable serializable;
            int n2 = 1;
            String string = threadDescriptor.getStackTrace();
            if (StringHelper.hasText(string) && n > 1) {
                serializable = s_aRWLock.writeLockedGet(() -> s_aIntErrCache.computeIfAbsent(string, string -> new MutableInt(-1)));
                ((MutableInt)serializable).inc();
                n2 = ((MutableInt)serializable).intValue();
                if (n2 % n != 0) {
                    LOGGER.warn("Not sending internal error mail, because this error occurred " + n2 + " times");
                    return;
                }
            }
            serializable = internalErrorEmailSettings.getSenderAddress();
            ICommonsList<IEmailAddress> iCommonsList = internalErrorEmailSettings.getAllReceiverAddresses();
            ISMTPSettings iSMTPSettings = internalErrorEmailSettings.getSMTPSettings();
            boolean bl2 = true;
            if (serializable == null) {
                LOGGER.warn("Not sending internal error mail, because 'sender' is not set!");
                bl2 = false;
            } else if (iCommonsList.isEmpty()) {
                LOGGER.warn("Not sending internal error mail, because 'receiver' is not set!");
                bl2 = false;
            } else if (iSMTPSettings == null) {
                LOGGER.warn("Not sending internal error mail, because 'SMTP settings' is not set!");
                bl2 = false;
            }
            if (bl2) {
                Serializable serializable2;
                String string2 = InternalErrorHandler._createMailSubject(internalErrorMetadata);
                String string3 = internalErrorMetadata.getAsString() + "\n---------------------------------------------------------------\n" + threadDescriptor.getAsString() + "\n---------------------------------------------------------------\n";
                if (threadDescriptorList != null) {
                    string3 = string3 + threadDescriptorList.getAsString() + "\n---------------------------------------------------------------\n";
                }
                if (bl) {
                    serializable2 = new StringBuilder("ClassPath:\n");
                    for (String string4 : ClassPathHelper.getAllClassPathEntries()) {
                        ((StringBuilder)serializable2).append("  ").append(string4).append('\n');
                    }
                    ((StringBuilder)serializable2).append("\n---------------------------------------------------------------\n");
                    string3 = string3 + ((StringBuilder)serializable2).toString();
                }
                serializable2 = new EmailData(EEmailType.TEXT);
                ((EmailData)serializable2).setFrom((IEmailAddress)serializable);
                ((EmailData)serializable2).to().addAll(iCommonsList);
                ((EmailData)serializable2).setSubject(string2);
                ((EmailData)serializable2).setBody(string3);
                ((EmailData)serializable2).setAttachments(iEmailAttachmentList);
                try {
                    if (ScopedMailAPI.getInstance().queueMail(iSMTPSettings, (IMutableEmailData)serializable2).isFailure()) {
                        LOGGER.warn("Failed to send via ScopedMailAPI");
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Failed to send via ScopedMailAPI: " + InternalErrorHandler._getThrowableAsString(throwable));
                    if (!MailAPI.queueMail(iSMTPSettings, (IMutableEmailData)serializable2).isFailure()) break block14;
                    LOGGER.warn("Failed to send via MailAPI as well");
                }
            }
        }
    }

    @Nonnull
    private static ESuccess _saveInternalErrorToXML(@Nonnull InternalErrorMetadata internalErrorMetadata, @Nonnull ThreadDescriptor threadDescriptor, @Nullable ThreadDescriptorList threadDescriptorList, @Nullable IEmailAttachmentList iEmailAttachmentList) {
        Serializable serializable;
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("internalerror");
        iMicroElement.appendChild(internalErrorMetadata.getAsMicroNode());
        iMicroElement.appendChild(threadDescriptor.getAsMicroNode());
        if (threadDescriptorList != null) {
            iMicroElement.appendChild(threadDescriptorList.getAsMicroNode());
        }
        if (iEmailAttachmentList != null && (serializable = iEmailAttachmentList.getAsDataSourceList()).isNotEmpty()) {
            IMicroElement iMicroElement2 = iMicroElement.appendElement("attachments");
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                IEmailAttachmentDataSource iEmailAttachmentDataSource = (IEmailAttachmentDataSource)iterator.next();
                IMicroElement iMicroElement3 = iMicroElement2.appendElement("attachment");
                iMicroElement3.setAttribute("name", iEmailAttachmentDataSource.getName());
                iMicroElement3.setAttribute("contenttype", iEmailAttachmentDataSource.getContentType());
                try {
                    iMicroElement3.appendText(Base64.encodeBytes(StreamHelper.getAllBytes(iEmailAttachmentDataSource.getInputStream())));
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to get content of attachment '" + iEmailAttachmentDataSource.getName() + "'", exception);
                    iMicroElement3.setAttribute("contentsavefailure", "true");
                }
            }
        }
        if ((serializable = (File)InternalErrorSettings.getStorageFileProvider().apply(internalErrorMetadata)) == null) {
            LOGGER.warn("The File provider returned null - not storing internal error as XML");
            return ESuccess.FAILURE;
        }
        return MicroWriter.writeToFile((IMicroNode)microDocument, serializable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static InternalErrorMetadata fillInternalErrorMetaData(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nullable String string3, @Nullable Map<String, String> map) {
        Object object;
        Object object2;
        InternalErrorMetadata internalErrorMetadata = new InternalErrorMetadata(string3);
        try {
            internalErrorMetadata.addField("UTCTime", PDTWebDateHelper.getAsStringXSD(ZonedDateTime.now(Clock.systemUTC())));
            internalErrorMetadata.addField("ZonedDateTime", PDTWebDateHelper.getAsStringXSD(PDTFactory.getCurrentZonedDateTime()));
            internalErrorMetadata.addField("LocalDateTime", PDTWebDateHelper.getAsStringXSD(PDTFactory.getCurrentLocalDateTime()));
            internalErrorMetadata.addField("CurrentTimeMillis", Long.toString(System.currentTimeMillis()));
        }
        catch (Exception exception) {
            internalErrorMetadata.addField("Time", "System.currentTimeMillis=" + Long.toString(System.currentTimeMillis()));
        }
        if (map != null) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                internalErrorMetadata.addField("[Custom] " + (String)object.getKey(), (String)object.getValue());
            }
        }
        if ((object2 = iRequestWebScopeWithoutResponse) == null) {
            try {
                object2 = WebScopeManager.getRequestScope();
            }
            catch (Throwable throwable) {
                LOGGER.warn("Failed to get request scope: " + InternalErrorHandler._getThrowableAsString(throwable));
            }
        }
        if (object2 != null) {
            if (!object2.isValid()) {
                internalErrorMetadata.addField("Request scope", "!!!Present but invalid!!!");
            }
            try {
                internalErrorMetadata.addField("Request URL", object2.getURLEncoded());
            }
            catch (Throwable throwable) {
                internalErrorMetadata.addFieldRetrievalError("Request URL", throwable);
            }
            internalErrorMetadata.addField("User agent", RequestHelper.getUserAgent(object2.getRequest()).getAsString());
            try {
                internalErrorMetadata.addField("Remote IP address", object2.getRemoteAddr());
            }
            catch (Throwable throwable) {
                internalErrorMetadata.addFieldRetrievalError("Remote IP address", throwable);
            }
            object = RequestHelper.getUAProfile(object2.getRequest());
            if (!((UAProfile)object).equals(UAProfile.EMPTY)) {
                internalErrorMetadata.addField("UAProfile", ((UAProfile)object).toString());
            }
            for (Map.Entry entry : object2.attrs().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
                internalErrorMetadata.addField("[Request Attr] " + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
            for (Map.Entry entry : object2.params().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
                internalErrorMetadata.addField("[Request Param] " + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        } else {
            internalErrorMetadata.addField("Request scope", "!!!Not present!!!");
        }
        object = null;
        if (object2 != null) {
            try {
                object = (ISessionWebScope)ScopeSessionManager.getInstance().getSessionScopeOfID(object2.getSessionID());
            }
            catch (Throwable throwable) {
                LOGGER.warn("Failed to get session scope from request scope: " + InternalErrorHandler._getThrowableAsString(throwable));
            }
        }
        if (object == null) {
            try {
                object = WebScopeManager.getSessionScope(false);
            }
            catch (Throwable throwable) {
                LOGGER.warn("Failed to get request scope: " + InternalErrorHandler._getThrowableAsString(throwable));
            }
        }
        if (object != null) {
            internalErrorMetadata.addField("SessionID", object.getID());
            for (Map.Entry entry : object.attrs().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
                internalErrorMetadata.addField("[Session] " + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        try {
            object = InetAddress.getLocalHost();
            internalErrorMetadata.addField("My host name", ((InetAddress)object).getHostName());
            internalErrorMetadata.addField("My IP address", ((InetAddress)object).getHostAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object2 != null) {
            object = object2.getRequest();
            try {
                for (Map.Entry entry : RequestLogger.getRequestFieldMap((HttpServletRequest)object).entrySet()) {
                    internalErrorMetadata.addRequestField((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to get request fields from " + object, throwable);
            }
            try {
                RequestHelper.getRequestHeaderMap((HttpServletRequest)object).forEachSingleHeader((string, string2) -> internalErrorMetadata.addRequestHeader((String)string, (String)string2), true);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to get request headers from " + object, throwable);
            }
            try {
                for (Map.Entry entry : RequestLogger.getRequestParameterMap((HttpServletRequest)object).entrySet()) {
                    internalErrorMetadata.addRequestParameter((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to get request parameters from " + object, throwable);
            }
            try {
                Cookie[] cookieArray = ServletHelper.getRequestCookies((HttpServletRequest)object);
                if (cookieArray == null) return internalErrorMetadata;
                for (Cookie cookie : cookieArray) {
                    internalErrorMetadata.addRequestCookie(cookie.getName(), cookie.getValue());
                }
                return internalErrorMetadata;
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to get request cookies from " + object, throwable);
                return internalErrorMetadata;
            }
        }
        internalErrorMetadata.addField("HttpServletRequest", "RequestScope does not contain an HttpServletRequest");
        return internalErrorMetadata;
    }

    private static void _notifyVendor(boolean bl, boolean bl2, @Nullable Throwable throwable, @Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nullable String string, @Nullable Map<String, String> map, @Nonnull InternalErrorEmailSettings internalErrorEmailSettings, @Nullable IEmailAttachmentList iEmailAttachmentList, boolean bl3, @Nonnegative int n) {
        InternalErrorMetadata internalErrorMetadata = InternalErrorHandler.fillInternalErrorMetaData(iRequestWebScopeWithoutResponse, string, map);
        ThreadDescriptor threadDescriptor = ThreadDescriptor.createForCurrentThread(throwable);
        ThreadDescriptorList threadDescriptorList = null;
        if (InternalErrorSettings.isDumpAllThreads()) {
            threadDescriptorList = ThreadDescriptorList.createWithAllThreads();
        }
        if (bl) {
            InternalErrorHandler._sendInternalErrorMailToVendor(internalErrorMetadata, threadDescriptor, threadDescriptorList, internalErrorEmailSettings, iEmailAttachmentList, bl3, n);
        }
        if (bl2) {
            InternalErrorHandler._saveInternalErrorToXML(internalErrorMetadata, threadDescriptor, threadDescriptorList, iEmailAttachmentList);
        }
    }

    @Nullable
    private static Locale _getSafeDisplayLocale() {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScopeOrNull();
        if (iRequestWebScope != null) {
            try {
                return RequestSettings.getDisplayLocale(iRequestWebScope);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return InternalErrorSettings.getFallbackLocale();
    }

    @Nonnull
    @Nonempty
    static String handleInternalError(boolean bl, boolean bl2, @Nullable IUIInternalErrorHandler iUIInternalErrorHandler, @Nullable Throwable throwable, @Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nullable Map<String, String> map, @Nullable IEmailAttachmentList iEmailAttachmentList, @Nullable Locale locale, boolean bl3, boolean bl4, @Nonnegative int n) {
        Locale locale2 = locale != null ? locale : InternalErrorHandler._getSafeDisplayLocale();
        String string = InternalErrorHandler.createNewInternalErrorID();
        LOGGER.error("handleInternalError " + string, throwable);
        if (iUIInternalErrorHandler != null) {
            iUIInternalErrorHandler.onInternalError(throwable, string, locale2);
        }
        if (GlobalDebug.isDebugMode()) {
            if (map != null) {
                LOGGER.error("Custom data: " + map);
            }
            if (throwable != null && StackTraceHelper.containsUnitTestElement(throwable.getStackTrace())) {
                throw new IllegalStateException("Error executing unit test", throwable);
            }
        } else {
            InternalErrorHandler._notifyVendor(bl, bl2, throwable, iRequestWebScopeWithoutResponse, string, map, InternalErrorSettings.getCopyOfEmailSettings(), iEmailAttachmentList, bl4, n);
        }
        if (bl3) {
            InternalErrorSettings.callbacks().forEach(iInternalErrorCallback -> iInternalErrorCallback.onInternalError(throwable, iRequestWebScopeWithoutResponse, string, locale2));
        }
        return string;
    }
}

