/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IHasMicroNodeRepresentation;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class InternalErrorMetadata
implements IHasMicroNodeRepresentation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalErrorMetadata.class);
    private final String m_sErrorID;
    private final ICommonsList<Entry> m_aFields = new CommonsArrayList<Entry>();
    private final ICommonsList<Entry> m_aRequestFields = new CommonsArrayList<Entry>();
    private final ICommonsList<Entry> m_aRequestHeaders = new CommonsArrayList<Entry>();
    private final ICommonsList<Entry> m_aRequestParameters = new CommonsArrayList<Entry>();
    private final ICommonsList<Entry> m_aRequestCookies = new CommonsArrayList<Entry>();
    private final ICommonsList<Entry> m_aSessionFields = new CommonsArrayList<Entry>();

    public InternalErrorMetadata(@Nullable String string) {
        this.m_sErrorID = string;
    }

    @Nullable
    public String getErrorID() {
        return this.m_sErrorID;
    }

    @Nonnull
    public InternalErrorMetadata addField(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aFields.add(new Entry(string, string2));
        return this;
    }

    @Nonnull
    public InternalErrorMetadata addFieldRetrievalError(@Nonnull @Nonempty String string, @Nonnull Throwable throwable) {
        String string2 = "Failed to get " + string + ": " + throwable.getMessage() + " -- " + throwable.getClass().getName();
        LOGGER.warn(string2);
        return this.addField(string, string2);
    }

    @Nullable
    public String getFieldValue(@Nullable String string, @Nullable String string2) {
        Entry entry2 = StringHelper.hasNoText(string) ? null : this.m_aFields.findFirst(entry -> entry.getKey().equals(string));
        return entry2 != null ? entry2.getValue() : string2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllFields() {
        return (ICommonsList)this.m_aFields.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestField(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestFields.add(new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestFields() {
        return (ICommonsList)this.m_aRequestFields.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestHeader(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestHeaders.add(new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestHeaders() {
        return (ICommonsList)this.m_aRequestHeaders.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestParameter(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestParameters.add(new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestParameters() {
        return (ICommonsList)this.m_aRequestParameters.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addRequestCookie(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aRequestCookies.add(new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllRequestCookies() {
        return (ICommonsList)this.m_aRequestCookies.getClone();
    }

    @Nonnull
    public InternalErrorMetadata addSessionField(@Nonnull @Nonempty String string, @Nullable String string2) {
        this.m_aSessionFields.add(new Entry(string, string2));
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Entry> getAllSessionFields() {
        return (ICommonsList)this.m_aSessionFields.getClone();
    }

    @Nonnull
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.m_aFields) {
            stringBuilder.append(entry.getAsString()).append('\n');
        }
        if (!this.m_aRequestFields.isEmpty()) {
            stringBuilder.append("Request:\n");
            for (Entry entry : this.m_aRequestFields) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aRequestHeaders.isEmpty()) {
            stringBuilder.append("Request header:\n");
            for (Entry entry : this.m_aRequestHeaders) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aRequestParameters.isEmpty()) {
            stringBuilder.append("Request parameters:\n");
            for (Entry entry : this.m_aRequestParameters) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aRequestCookies.isEmpty()) {
            stringBuilder.append("Request cookies:\n");
            for (Entry entry : this.m_aRequestCookies) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        if (!this.m_aSessionFields.isEmpty()) {
            stringBuilder.append("Session field:\n");
            for (Entry entry : this.m_aSessionFields) {
                stringBuilder.append("  ").append(entry.getAsString()).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroNode() {
        MicroElement microElement = new MicroElement("metadata");
        microElement.setAttribute("errorid", this.m_sErrorID);
        IMicroElement iMicroElement = microElement.appendElement("fields");
        for (Entry entry : this.m_aFields) {
            iMicroElement.appendChild(entry.getAsMicroNode());
        }
        if (!this.m_aRequestFields.isEmpty()) {
            iMicroElement = microElement.appendElement("requestfields");
            for (Entry entry : this.m_aRequestFields) {
                iMicroElement.appendChild(entry.getAsMicroNode());
            }
        }
        if (!this.m_aRequestHeaders.isEmpty()) {
            iMicroElement = microElement.appendElement("requestheaders");
            for (Entry entry : this.m_aRequestHeaders) {
                iMicroElement.appendChild(entry.getAsMicroNode());
            }
        }
        if (!this.m_aRequestParameters.isEmpty()) {
            iMicroElement = microElement.appendElement("requestparameters");
            for (Entry entry : this.m_aRequestParameters) {
                iMicroElement.appendChild(entry.getAsMicroNode());
            }
        }
        if (!this.m_aRequestCookies.isEmpty()) {
            iMicroElement = microElement.appendElement("requestcookies");
            for (Entry entry : this.m_aRequestCookies) {
                iMicroElement.appendChild(entry.getAsMicroNode());
            }
        }
        if (!this.m_aSessionFields.isEmpty()) {
            iMicroElement = microElement.appendElement("sessionfields");
            for (Entry entry : this.m_aSessionFields) {
                iMicroElement.appendChild(entry.getAsMicroNode());
            }
        }
        return microElement;
    }

    @Immutable
    public static final class Entry
    implements IHasMicroNodeRepresentation {
        private final String m_sKey;
        private final String m_sValue;

        public Entry(@Nonnull @Nonempty String string, @Nullable String string2) {
            this.m_sKey = ValueEnforcer.notEmpty(string, "Key");
            this.m_sValue = string2;
        }

        @Nonnull
        @Nonempty
        public String getKey() {
            return this.m_sKey;
        }

        @Nullable
        public String getValue() {
            return this.m_sValue;
        }

        @Nonnull
        @Nonempty
        public String getAsString() {
            return this.m_sKey + ": " + this.m_sValue;
        }

        @Override
        @Nonnull
        public IMicroElement getAsMicroNode() {
            MicroElement microElement = new MicroElement("entry");
            microElement.setAttribute("key", this.m_sKey);
            microElement.appendText(this.m_sValue);
            return microElement;
        }
    }
}

