/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.functional.IFunction;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.core.interror.InternalErrorEmailSettings;
import com.helger.photon.core.interror.InternalErrorMetadata;
import com.helger.photon.core.interror.callback.IInternalErrorCallback;
import com.helger.smtp.settings.ISMTPSettings;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InternalErrorSettings {
    public static final boolean DEFAULT_ENABLE_FULL_THREAD_DUMPS = false;
    public static final boolean DEFAULT_SEND_EMAIL = true;
    public static final boolean DEFAULT_SAVE_AS_XML = true;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final InternalErrorEmailSettings s_aEmailSettings = new InternalErrorEmailSettings();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bEnableDumpAllThreads = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bSendEmail = true;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bSaveAsXML = true;
    @GuardedBy(value="s_aRWLock")
    private static Locale s_aFallbackLocale = CGlobal.DEFAULT_LOCALE;
    private static CallbackList<IInternalErrorCallback> s_aCallbacks = new CallbackList();
    private static IFunction<InternalErrorMetadata, File> s_aStorageFileProvider;

    private InternalErrorSettings() {
    }

    public static void setSMTPSettings(@Nullable ISMTPSettings iSMTPSettings) {
        s_aRWLock.writeLockedGet(() -> s_aEmailSettings.setSMTPSettings(iSMTPSettings));
    }

    @Nullable
    public static ISMTPSettings getSMTPSettings() {
        return s_aRWLock.readLockedGet(() -> s_aEmailSettings.getSMTPSettings());
    }

    public static void setSMTPSenderAddress(@Nullable IEmailAddress iEmailAddress) {
        s_aRWLock.writeLockedGet(() -> s_aEmailSettings.setSenderAddress(iEmailAddress));
    }

    @Nullable
    public static IEmailAddress getSMTPSenderAddress() {
        return s_aRWLock.readLockedGet(s_aEmailSettings::getSenderAddress);
    }

    public static void setSMTPReceiverAddress(@Nullable IEmailAddress iEmailAddress) {
        s_aRWLock.writeLockedGet(() -> s_aEmailSettings.setReceiverAddress(iEmailAddress));
    }

    public static void setSMTPReceiverAddresses(@Nullable Iterable<? extends IEmailAddress> iterable) {
        s_aRWLock.writeLockedGet(() -> s_aEmailSettings.setReceiverAddresses(iterable));
    }

    public static void setSMTPReceiverAddresses(IEmailAddress ... iEmailAddressArray) {
        s_aRWLock.writeLockedGet(() -> s_aEmailSettings.setReceiverAddresses(iEmailAddressArray));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IEmailAddress> getSMTPReceiverAddresses() {
        return s_aRWLock.readLockedGet(s_aEmailSettings::getAllReceiverAddresses);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static InternalErrorEmailSettings getCopyOfEmailSettings() {
        return s_aRWLock.readLockedGet(s_aEmailSettings::getClone);
    }

    public static void setDumpAllThreads(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bEnableDumpAllThreads = bl;
            return s_bEnableDumpAllThreads;
        });
    }

    public static boolean isDumpAllThreads() {
        return s_aRWLock.readLockedBoolean(() -> s_bEnableDumpAllThreads);
    }

    public static void setSendEmail(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bSendEmail = bl;
            return s_bSendEmail;
        });
    }

    public static boolean isSendEmail() {
        return s_aRWLock.readLockedBoolean(() -> s_bSendEmail);
    }

    public static void setSaveAsXML(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bSaveAsXML = bl;
            return s_bSaveAsXML;
        });
    }

    public static boolean isSaveAsXML() {
        return s_aRWLock.readLockedBoolean(() -> s_bSaveAsXML);
    }

    public static void setFallbackLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "FallbackLocale");
        s_aRWLock.writeLockedGet(() -> {
            s_aFallbackLocale = locale;
            return s_aFallbackLocale;
        });
    }

    @Nonnull
    public static Locale getFallbackLocale() {
        return s_aRWLock.readLockedGet(() -> s_aFallbackLocale);
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IInternalErrorCallback> callbacks() {
        return s_aCallbacks;
    }

    @Nonnull
    public static IFunction<InternalErrorMetadata, File> getStorageFileProvider() {
        return s_aStorageFileProvider;
    }

    public static void setStorageFileProvider(@Nonnull IFunction<InternalErrorMetadata, File> iFunction) {
        ValueEnforcer.notNull(iFunction, "StorageFileProvider");
        s_aStorageFileProvider = iFunction;
    }

    public static void setDefaultStorageFileProvider() {
        InternalErrorSettings.setStorageFileProvider(internalErrorMetadata -> {
            LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
            String string = StringHelper.getConcatenatedOnDemand(PDTIOHelper.getLocalDateTimeForFilename(localDateTime), "-", internalErrorMetadata.getErrorID()) + ".xml";
            return WebFileIO.getDataIO().getFile("internal-errors/" + localDateTime.getYear() + "/" + StringHelper.getLeadingZero(localDateTime.getMonthValue(), 2) + "/" + string);
        });
    }

    public static void setDefaultStorageFileProviderUpTo802() {
        InternalErrorSettings.setStorageFileProvider(internalErrorMetadata -> {
            LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
            String string = StringHelper.getConcatenatedOnDemand(PDTIOHelper.getLocalDateTimeForFilename(localDateTime), "-", internalErrorMetadata.getErrorID()) + ".xml";
            return WebFileIO.getDataIO().getFile("internal-errors/" + localDateTime.getYear() + "/" + string);
        });
    }

    static {
        InternalErrorSettings.setDefaultStorageFileProvider();
    }
}

