/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror.callback;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.map.LRUSet;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.dao.AbstractDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import com.helger.photon.ajax.AjaxSettings;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.callback.IAjaxExceptionCallback;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.api.APISettings;
import com.helger.photon.api.IAPIExceptionCallback;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.photon.core.interror.InternalErrorHandler;
import com.helger.photon.core.longrun.ILongRunningJob;
import com.helger.quartz.IJob;
import com.helger.schedule.job.AbstractJob;
import com.helger.schedule.job.IJobExceptionCallback;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.requesttrack.ILongRunningRequestCallback;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.RequestTracker;
import com.helger.xservlet.requesttrack.TrackedRequest;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractErrorCallback
implements IAjaxExceptionCallback,
IAPIExceptionCallback,
IDAOReadExceptionCallback,
IDAOWriteExceptionCallback,
IJobExceptionCallback,
ILongRunningRequestCallback,
IParallelRunningRequestCallback {
    private final ICommonsSet<String> m_aHandledLongRunning = new LRUSet<String>(1000);

    protected abstract void onError(@Nullable Throwable var1, @Nullable IRequestWebScopeWithoutResponse var2, @Nonnull @Nonempty String var3, @Nullable Map<String, String> var4);

    @Override
    public void onAjaxExecutionException(@Nullable IAjaxInvoker iAjaxInvoker, @Nullable String string, @Nonnull IAjaxExecutor iAjaxExecutor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Exception exception) {
        String string2 = "ajax-error-" + (StringHelper.hasText(string) ? string + "-" : "") + InternalErrorHandler.createNewErrorID();
        this.onError(exception, iRequestWebScopeWithoutResponse, string2, new StringMap().add("ajax-function-name", string));
    }

    @Override
    public void onAPIExecutionException(@Nullable IAPIInvoker iAPIInvoker, @Nonnull InvokableAPIDescriptor invokableAPIDescriptor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Throwable throwable) {
        String string = "api-error-" + InternalErrorHandler.createNewErrorID() + "-" + invokableAPIDescriptor.getPath();
        this.onError(throwable, iRequestWebScopeWithoutResponse, string, new StringMap().add("api-path", invokableAPIDescriptor.getPath()));
    }

    @Override
    public void onDAOReadException(@Nonnull Throwable throwable, boolean bl, @Nullable IReadableResource iReadableResource) {
        String string = "DAO " + (bl ? "init" : "read") + " error" + (iReadableResource == null ? "" : " for " + iReadableResource.getPath());
        this.onError(throwable, null, string, new StringMap().add("action", bl ? "init" : "read").add("path", iReadableResource == null ? null : iReadableResource.getPath()));
    }

    @Override
    public void onDAOWriteException(@Nonnull Throwable throwable, @Nonnull IReadableResource iReadableResource, @Nonnull CharSequence charSequence) {
        String string = "DAO write error for " + iReadableResource.getPath() + " with " + charSequence.length() + " chars";
        this.onError(throwable, null, string, new StringMap().add("action", "write").add("path", iReadableResource.getPath()).add("content", charSequence));
    }

    @Override
    public void onScheduledJobException(@Nonnull Throwable throwable, @Nullable String string, @Nonnull IJob iJob) {
        this.onError(throwable, null, "Error executing background job " + string, new StringMap().addIfNotNull("job-class", string).add("job-object", iJob).add("long-running", iJob instanceof ILongRunningJob));
    }

    @Override
    public void onLongRunningRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope, @Nonnegative long l) {
        if (this.m_aHandledLongRunning.add(string)) {
            this.onError(null, iRequestWebScope, "Long running request.", new StringMap().add("request-id", string).add("millisecconds", l).add("URL", iRequestWebScope.getURLEncoded()));
        }
    }

    @Override
    public void onParallelRunningRequests(@Nonnegative int n, @Nonnull @Nonempty List<TrackedRequest> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TrackedRequest trackedRequest : list) {
            stringBuilder.append('\n').append(trackedRequest.getRequestScope().getURLEncoded());
        }
        this.onError(null, null, "Currently " + n + " parallel requests are active: " + stringBuilder.toString(), new StringMap().add("parallel-requests", n));
    }

    @Override
    public void onParallelRunningRequestsBelowLimit() {
    }

    @OverrideOnDemand
    public void install() {
        AbstractErrorCallback.installToPhoton(this);
    }

    public static void installToPhoton(@Nonnull AbstractErrorCallback abstractErrorCallback) {
        AjaxSettings.exceptionCallbacks().add(abstractErrorCallback);
        APISettings.exceptionCallbacks().add(abstractErrorCallback);
        AbstractDAO.exceptionHandlersRead().add(abstractErrorCallback);
        AbstractDAO.exceptionHandlersWrite().add(abstractErrorCallback);
        AbstractJob.exceptionCallbacks().add(abstractErrorCallback);
        RequestTracker.longRunningRequestCallbacks().add(abstractErrorCallback);
        RequestTracker.parallelRunningRequestCallbacks().add(abstractErrorCallback);
    }
}

