/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.core.interror.callback;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.deadlock.IThreadDeadlockCallback;
import com.helger.commons.deadlock.ThreadDeadlockInfo;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.photon.core.interror.InternalErrorHandler;
import com.helger.photon.core.interror.InternalErrorSettings;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.xml.util.thread.ThreadDescriptor;
import com.helger.xml.util.thread.ThreadDescriptorList;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailingThreadDeadlockCallback
implements IThreadDeadlockCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailingThreadDeadlockCallback.class);

    @Nonnull
    public static String getAsString(@Nonnull ThreadDeadlockInfo threadDeadlockInfo) {
        ValueEnforcer.notNull(threadDeadlockInfo, "TDI");
        StringBuilder stringBuilder = new StringBuilder(threadDeadlockInfo.getThreadInfo().toString());
        StackTraceElement[] stackTraceElementArray = threadDeadlockInfo.getAllStackTraceElements();
        if (stackTraceElementArray != null) {
            stringBuilder.append(StackTraceHelper.getStackAsString(stackTraceElementArray, false));
        }
        return stringBuilder.toString();
    }

    @Override
    public void onDeadlockDetected(@Nonnull @Nonempty ThreadDeadlockInfo[] threadDeadlockInfoArray) {
        LOGGER.warn("Deadlock of " + ArrayHelper.getSize(threadDeadlockInfoArray) + " threads detected!");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(InternalErrorHandler.fillInternalErrorMetaData(null, null, null).getAsString());
        for (ThreadDeadlockInfo threadDeadlockInfo : threadDeadlockInfoArray) {
            stringBuilder.append('\n').append(MailingThreadDeadlockCallback.getAsString(threadDeadlockInfo));
        }
        stringBuilder.append("\n---------------------------------------------------------------\n").append(ThreadDescriptor.createForCurrentThread(null).getAsString()).append("\n---------------------------------------------------------------\n").append(ThreadDescriptorList.createWithAllThreads().getAsString()).append("\n---------------------------------------------------------------");
        EmailData emailData = new EmailData(EEmailType.TEXT);
        emailData.setFrom(InternalErrorSettings.getSMTPSenderAddress());
        emailData.to().addAll(InternalErrorSettings.getSMTPReceiverAddresses());
        emailData.setSubject("[ph-oton] Dead lock of " + threadDeadlockInfoArray.length + " threads detected");
        emailData.setBody(stringBuilder.toString());
        ScopedMailAPI.getInstance().queueMail(InternalErrorSettings.getSMTPSettings(), emailData);
    }
}

